/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;

public class LiferayPortlet
extends GenericPortlet {
    private static final boolean _PROCESS_PORTLET_REQUEST = true;
    private Map<String, Class<?>> _classesMap = new HashMap();
    private Map<MethodKey, Method> _methodsMap = new HashMap<MethodKey, Method>();

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        String redirect;
        if (!this.isProcessActionRequest(actionRequest)) {
            return;
        }
        if (!this.callActionMethod(actionRequest, actionResponse)) {
            return;
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            SessionMessages.add((PortletRequest)actionRequest, "request_processed");
        }
        if (Validator.isNotNull(redirect = ParamUtil.getString((PortletRequest)actionRequest, "redirect"))) {
            actionResponse.sendRedirect(redirect);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (!this.isProcessResourceRequest(resourceRequest)) {
            return;
        }
        super.serveResource(resourceRequest, resourceResponse);
    }

    protected boolean callActionMethod(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, "javax.portlet.action");
        if (Validator.isNull(actionName)) {
            return false;
        }
        try {
            Method method = MethodCache.get(this._classesMap, this._methodsMap, ((Object)((Object)this)).getClass().getName(), actionName, new Class[]{ActionRequest.class, ActionResponse.class});
            method.invoke((Object)this, actionRequest, actionResponse);
            return true;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause != null) {
                throw new PortletException(cause);
            }
            throw new PortletException((Throwable)ite);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (!this.isProcessRenderRequest(renderRequest)) {
            renderRequest.setAttribute("PORTLET_DECORATE", (Object)Boolean.FALSE);
            return;
        }
        WindowState state = renderRequest.getWindowState();
        if (state.equals((Object)WindowState.MINIMIZED)) {
            return;
        }
        PortletMode mode = renderRequest.getPortletMode();
        if (mode.equals((Object)PortletMode.VIEW)) {
            this.doView(renderRequest, renderResponse);
        } else if (mode.equals((Object)LiferayPortletMode.ABOUT)) {
            this.doAbout(renderRequest, renderResponse);
        } else if (mode.equals((Object)LiferayPortletMode.CONFIG)) {
            this.doConfig(renderRequest, renderResponse);
        } else if (mode.equals((Object)PortletMode.EDIT)) {
            this.doEdit(renderRequest, renderResponse);
        } else if (mode.equals((Object)LiferayPortletMode.EDIT_DEFAULTS)) {
            this.doEditDefaults(renderRequest, renderResponse);
        } else if (mode.equals((Object)LiferayPortletMode.EDIT_GUEST)) {
            this.doEditGuest(renderRequest, renderResponse);
        } else if (mode.equals((Object)PortletMode.HELP)) {
            this.doHelp(renderRequest, renderResponse);
        } else if (mode.equals((Object)LiferayPortletMode.PREVIEW)) {
            this.doPreview(renderRequest, renderResponse);
        } else if (mode.equals((Object)LiferayPortletMode.PRINT)) {
            this.doPrint(renderRequest, renderResponse);
        } else {
            throw new PortletException(mode.toString());
        }
    }

    protected void doAbout(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doAbout method not implemented");
    }

    protected void doConfig(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doConfig method not implemented");
    }

    protected void doEditDefaults(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doEditDefaults method not implemented");
    }

    protected void doEditGuest(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doEditGuest method not implemented");
    }

    protected void doPreview(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doPreview method not implemented");
    }

    protected void doPrint(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doPrint method not implemented");
    }

    protected boolean isProcessActionRequest(ActionRequest actionRequest) {
        return this.isProcessPortletRequest((PortletRequest)actionRequest);
    }

    protected boolean isProcessPortletRequest(PortletRequest portletRequest) {
        return true;
    }

    protected boolean isProcessRenderRequest(RenderRequest renderRequest) {
        return this.isProcessPortletRequest((PortletRequest)renderRequest);
    }

    protected boolean isProcessResourceRequest(ResourceRequest resourceRequest) {
        return this.isProcessPortletRequest((PortletRequest)resourceRequest);
    }
}

