/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.RenderRequest;
import javax.portlet.filter.RenderRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicRenderRequest
extends RenderRequestWrapper {
    private Map<String, String[]> _params = new HashMap<String, String[]>();
    private boolean _inherit;

    public DynamicRenderRequest(RenderRequest renderRequest) {
        this(renderRequest, new HashMap<String, String[]>(), true);
    }

    public DynamicRenderRequest(RenderRequest renderRequest, Map<String, String[]> params) {
        this(renderRequest, params, true);
    }

    public DynamicRenderRequest(RenderRequest renderRequest, boolean inherit) {
        this(renderRequest, new HashMap<String, String[]>(), inherit);
    }

    public DynamicRenderRequest(RenderRequest renderRequest, Map<String, String[]> params, boolean inherit) {
        super(renderRequest);
        this._inherit = inherit;
        if (params != null) {
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                this._params.put(entry.getKey(), entry.getValue());
            }
        }
        if (this._inherit && renderRequest instanceof DynamicRenderRequest) {
            DynamicRenderRequest dynamicRenderRequest = (DynamicRenderRequest)renderRequest;
            this.setRequest(dynamicRenderRequest.getRequest());
            params = dynamicRenderRequest.getDynamicParameterMap();
            if (params != null) {
                for (Map.Entry<String, String[]> entry : params.entrySet()) {
                    String name = entry.getKey();
                    String[] oldValues = entry.getValue();
                    String[] curValues = this._params.get(name);
                    if (curValues == null) {
                        this._params.put(name, oldValues);
                        continue;
                    }
                    String[] newValues = ArrayUtil.append(oldValues, curValues);
                    this._params.put(name, newValues);
                }
            }
        }
    }

    public String getParameter(String name) {
        String[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameter(name);
        }
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String s = enu.nextElement();
            map.put(s, this.getParameterValues(s));
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        ArrayList names = new ArrayList();
        if (this._inherit) {
            Enumeration enu = super.getParameterNames();
            while (enu.hasMoreElements()) {
                names.add(enu.nextElement());
            }
        }
        for (String s : this._params.keySet()) {
            if (names.contains(s)) continue;
            names.add(s);
        }
        return Collections.enumeration(names);
    }

    public String[] getParameterValues(String name) {
        String[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameterValues(name);
        }
        return values;
    }

    public void setParameter(String name, String value) {
        this._params.put(name, new String[]{value});
    }

    public void setParameterValues(String name, String[] values) {
        this._params.put(name, values);
    }

    public Map<String, String[]> getDynamicParameterMap() {
        return this._params;
    }
}

