/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.util.PortalClassInvoker;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFriendlyURLMapper
implements FriendlyURLMapper {
    private static final boolean _CHECK_MAPPING_WITH_PREFIX = true;
    private static final String _CLASS = "com.liferay.portal.util.PortalUtil";
    private static final String _METHOD_GETPORTLETNAMESPACE = "getPortletNamespace";
    private static final String _METHOD_ISRESERVEDPARAMETER = "isReservedParameter";
    private static Log _log = LogFactoryUtil.getLog(BaseFriendlyURLMapper.class);

    public abstract String getPortletId();

    @Override
    public boolean isCheckMappingWithPrefix() {
        return true;
    }

    protected void addParam(Map<String, String[]> params, String name, boolean value) {
        this.addParam(params, name, String.valueOf(value));
    }

    protected void addParam(Map<String, String[]> params, String name, double value) {
        this.addParam(params, name, String.valueOf(value));
    }

    protected void addParam(Map<String, String[]> params, String name, int value) {
        this.addParam(params, name, String.valueOf(value));
    }

    protected void addParam(Map<String, String[]> params, String name, long value) {
        this.addParam(params, name, String.valueOf(value));
    }

    protected void addParam(Map<String, String[]> params, String name, short value) {
        this.addParam(params, name, String.valueOf(value));
    }

    protected void addParam(Map<String, String[]> params, String name, Object value) {
        this.addParam(params, name, String.valueOf(value));
    }

    protected void addParam(Map<String, String[]> params, String name, String value) {
        try {
            if (!this._isReservedParameter(name)) {
                name = this.getNamespace() + name;
            }
            params.put(name, new String[]{value});
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    protected String getNamespace() {
        try {
            return this._getPortletNamespace(this.getPortletId());
        }
        catch (Exception e) {
            _log.error(e, e);
            return this.getPortletId();
        }
    }

    private String _getPortletNamespace(String portletId) throws Exception {
        Object returnObj = PortalClassInvoker.invoke(_CLASS, _METHOD_GETPORTLETNAMESPACE, (Object)portletId, false);
        if (returnObj != null) {
            return (String)returnObj;
        }
        return null;
    }

    private boolean _isReservedParameter(String name) throws Exception {
        Object returnObj = PortalClassInvoker.invoke(_CLASS, _METHOD_ISRESERVEDPARAMETER, (Object)name, false);
        if (returnObj != null) {
            return (Boolean)returnObj;
        }
        return false;
    }
}

