/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;

public class MessageBusUtil {
    private static MessageBusUtil _instance = new MessageBusUtil();
    private MessageBus _messageBus;
    private MessageSender _messageSender;
    private SynchronousMessageSender _synchronousMessageSender;

    public static void addDestination(Destination destination) {
        _instance._addDestination(destination);
    }

    public static MessageBus getMessageBus() {
        return MessageBusUtil._instance._messageBus;
    }

    public static MessageSender getMessageSender() {
        return MessageBusUtil._instance._messageSender;
    }

    public static boolean hasMessageListener(String destination) {
        return _instance._hasMessageListener(destination);
    }

    public static void init(MessageBus messageBus, MessageSender messageSender, SynchronousMessageSender synchronousMessageSender) {
        _instance._init(messageBus, messageSender, synchronousMessageSender);
    }

    public static void registerMessageListener(String destination, MessageListener listener) {
        _instance._registerMessageListener(destination, listener);
    }

    public static void removeDestination(String destination) {
        _instance._removeDestination(destination);
    }

    public static void sendMessage(String destination, Message message) {
        _instance._sendMessage(destination, message);
    }

    public static void sendMessage(String destination, Object payload) {
        _instance._sendMessage(destination, payload);
    }

    public static Object sendSynchronousMessage(String destination, Message message) throws MessageBusException {
        return _instance._sendSynchronousMessage(destination, message);
    }

    public static Object sendSynchronousMessage(String destination, Object payload) throws MessageBusException {
        return _instance._sendSynchronousMessage(destination, payload);
    }

    public static Object sendSynchronousMessage(String destination, Message message, long timeout) throws MessageBusException {
        return _instance._sendSynchronousMessage(destination, message, timeout);
    }

    public static Object sendSynchronousMessage(String destination, Object payload, long timeout) throws MessageBusException {
        return _instance._sendSynchronousMessage(destination, payload, timeout);
    }

    public static boolean unregisterMessageListener(String destination, MessageListener listener) {
        return _instance._unregisterMessageListener(destination, listener);
    }

    private MessageBusUtil() {
    }

    private void _addDestination(Destination destination) {
        this._messageBus.addDestination(destination);
    }

    private boolean _hasMessageListener(String destination) {
        return this._messageBus.hasMessageListener(destination);
    }

    private void _init(MessageBus messageBus, MessageSender messageSender, SynchronousMessageSender synchronousMessageSender) {
        this._messageBus = messageBus;
        this._messageSender = messageSender;
        this._synchronousMessageSender = synchronousMessageSender;
    }

    private void _registerMessageListener(String destination, MessageListener listener) {
        this._messageBus.registerMessageListener(destination, listener);
    }

    private void _removeDestination(String destination) {
        this._messageBus.removeDestination(destination);
    }

    private void _sendMessage(String destination, Message message) {
        this._messageBus.sendMessage(destination, message);
    }

    private void _sendMessage(String destination, Object payload) {
        Message message = new Message();
        message.setPayload(payload);
        this._sendMessage(destination, message);
    }

    private Object _sendSynchronousMessage(String destination, Message message) throws MessageBusException {
        return this._synchronousMessageSender.sendMessage(destination, message);
    }

    private Object _sendSynchronousMessage(String destination, Object payload) throws MessageBusException {
        Message message = new Message();
        message.setPayload(payload);
        return this._sendSynchronousMessage(destination, message);
    }

    private Object _sendSynchronousMessage(String destination, Message message, long timeout) throws MessageBusException {
        return this._synchronousMessageSender.sendMessage(destination, message, timeout);
    }

    private Object _sendSynchronousMessage(String destination, Object payload, long timeout) throws MessageBusException {
        Message message = new Message();
        message.setPayload(payload);
        return this._sendSynchronousMessage(destination, message, timeout);
    }

    private boolean _unregisterMessageListener(String destination, MessageListener listener) {
        return this._messageBus.unregisterMessageListener(destination, listener);
    }
}

