/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HotDeployUtil {
    private static Log _log = LogFactoryUtil.getLog(HotDeployUtil.class);
    private static HotDeployUtil _instance = new HotDeployUtil();
    private List<HotDeployEvent> _dependentEvents;
    private Set<String> _deployedServletContextNames;
    private List<HotDeployListener> _listeners;
    private List<HotDeployEvent> _prematureEvents;

    public static void fireDeployEvent(HotDeployEvent event) {
        _instance._fireDeployEvent(event);
    }

    public static void fireUndeployEvent(HotDeployEvent event) {
        _instance._fireUndeployEvent(event);
    }

    public static void flushPrematureEvents() {
        _instance._flushPrematureEvents();
    }

    public static void registerListener(HotDeployListener listener) {
        _instance._registerListener(listener);
    }

    public static void unregisterListeners() {
        _instance._unregisterListeners();
    }

    private HotDeployUtil() {
        if (_log.isInfoEnabled()) {
            _log.info("Initializing hot deploy manager " + this.hashCode());
        }
        this._dependentEvents = new ArrayList<HotDeployEvent>();
        this._deployedServletContextNames = new HashSet<String>();
        this._listeners = new ArrayList<HotDeployListener>();
        this._prematureEvents = new ArrayList<HotDeployEvent>();
    }

    private void _doFireDeployEvent(HotDeployEvent event) {
        if (this._deployedServletContextNames.contains(event.getServletContextName())) {
            return;
        }
        boolean hasDependencies = true;
        Set<String> dependentServletContextNames = event.getDependentServletContextNames();
        for (String dependentServletContextName : dependentServletContextNames) {
            if (this._deployedServletContextNames.contains(dependentServletContextName)) continue;
            hasDependencies = false;
            break;
        }
        if (hasDependencies) {
            if (this._dependentEvents.contains(event) && _log.isInfoEnabled()) {
                _log.info("Deploy " + event.getServletContextName() + " from queue");
            }
            for (HotDeployListener listener : this._listeners) {
                try {
                    listener.invokeDeploy(event);
                }
                catch (HotDeployException hde) {
                    _log.error(hde, hde);
                }
            }
            this._deployedServletContextNames.add(event.getServletContextName());
            this._dependentEvents.remove(event);
            ArrayList<HotDeployEvent> dependentEvents = new ArrayList<HotDeployEvent>(this._dependentEvents);
            for (HotDeployEvent dependentEvent : dependentEvents) {
                this._doFireDeployEvent(dependentEvent);
            }
        } else if (!this._dependentEvents.contains(event)) {
            if (_log.isInfoEnabled()) {
                _log.info("Queue " + event.getServletContextName() + " for deploy because its dependencies are not " + "available");
            }
            this._dependentEvents.add(event);
        }
    }

    private void _fireDeployEvent(HotDeployEvent event) {
        if (this._prematureEvents != null) {
            this._prematureEvents.add(event);
            return;
        }
        this._doFireDeployEvent(event);
    }

    private void _fireUndeployEvent(HotDeployEvent event) {
        for (HotDeployListener listener : this._listeners) {
            try {
                listener.invokeUndeploy(event);
            }
            catch (HotDeployException hde) {
                _log.error(hde, hde);
            }
        }
        this._deployedServletContextNames.remove(event.getServletContextName());
    }

    private void _flushPrematureEvents() {
        for (HotDeployEvent event : this._prematureEvents) {
            this._doFireDeployEvent(event);
        }
        this._prematureEvents = null;
    }

    private void _registerListener(HotDeployListener listener) {
        this._listeners.add(listener);
    }

    private void _unregisterListeners() {
        this._listeners.clear();
    }
}

