/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.jdbc;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class SmartResultSet {
    private final ResultSet _rs;
    private final ResultSetMetaData _metaData;
    private final int _columnCount;
    private final Map<String, Integer> _columnIndexCache;

    public SmartResultSet(ResultSet rs) throws SQLException {
        this._rs = rs;
        this._metaData = this._rs.getMetaData();
        this._columnCount = this._metaData.getColumnCount();
        this._columnIndexCache = new HashMap<String, Integer>();
    }

    public int findColumn(String columnName) throws SQLException {
        Integer columnIndex = this._columnIndexCache.get(columnName);
        if (columnIndex != null) {
            return columnIndex;
        }
        for (int i = 1; i <= this._columnCount; ++i) {
            String availableName = this._metaData.getColumnName(i);
            if (!availableName.equalsIgnoreCase(columnName)) continue;
            this._columnIndexCache.put(columnName, i);
            return i;
        }
        int pos = columnName.indexOf(46);
        if (pos != -1) {
            String shortName = columnName.substring(pos + 1);
            for (int i = 1; i <= this._columnCount; ++i) {
                String availableName = this._metaData.getColumnName(i);
                if (!availableName.equalsIgnoreCase(shortName)) continue;
                this._columnIndexCache.put(columnName, i);
                return i;
            }
        }
        columnIndex = this._rs.findColumn(columnName);
        this._columnIndexCache.put(columnName, columnIndex);
        return columnIndex;
    }

    public boolean first() throws SQLException {
        return this._rs.first();
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this._rs.getDate(columnIndex);
    }

    public Date getDate(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this._rs.getDate(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this._rs.getDouble(columnIndex);
    }

    public double getDouble(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this._rs.getDouble(columnIndex);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this._rs.getFloat(columnIndex);
    }

    public float getFloat(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this._rs.getFloat(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this._rs.getInt(columnIndex);
    }

    public int getInt(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this._rs.getInt(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this._rs.getLong(columnIndex);
    }

    public long getLong(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this._rs.getLong(columnIndex);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this._rs.getShort(columnIndex);
    }

    public short getShort(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this._rs.getShort(columnIndex);
    }

    public String getString(int columnIndex) throws SQLException {
        return this._rs.getString(columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this._rs.getString(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this._rs.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this._rs.getTimestamp(columnIndex);
    }

    public boolean last() throws SQLException {
        return this._rs.last();
    }

    public boolean next() throws SQLException {
        return this._rs.next();
    }

    public boolean previous() throws SQLException {
        return this._rs.previous();
    }
}

