/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Properties;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;

@ProxyFor(value={OracleConnection.class})
@ProxyLocale
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableConnection
extends TxnReplayableBase
implements JDBCReplayable,
ReplayableConnection {
    private static final Method CREATEARRAY_METHOD = TxnReplayableConnection.getCreateARRAYMethod();
    private static final Method CREATEARRAYOF_METHOD = TxnReplayableConnection.getCreateArrayOfMethod();
    private static final Method CREATESTRUCT_METHOD = TxnReplayableConnection.getCreateStructMethod();
    String originalUser = "";
    String originalPasswd = "";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";

    protected TxnReplayableConnection() {
        this.thisProxyNameInLog = "CONN" + this.thisProxyNameInLog;
    }

    private static final Method getCreateARRAYMethod() {
        try {
            return OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateArrayOfMethod() {
        try {
            return Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateStructMethod() {
        try {
            return Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class}), @Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class})})
    protected void preForStatementCreation(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={})})
    protected void preForAbort(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void preForClosure(Method method, Object object, Object ... objectArray) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = stackTraceElementArray != null && stackTraceElementArray.length > 4 ? stackTraceElementArray[4].getClassName() : "";
        this.isClosedAndNoReplay = !string.startsWith("oracle.ucp");
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="openProxySession", args={int.class, Properties.class})})
    protected void preForOpenProxySession(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={})})
    protected void postForAbort(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method method) {
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int n2) throws SQLException {
        this.failoverMngr.setReplayInitiationTimeout(n2);
    }

    @Override
    public void initialize(OracleDataSource oracleDataSource, String string, String string2) throws SQLException {
        TxnFailoverManagerImpl txnFailoverManagerImpl = (TxnFailoverManagerImpl)TxnFailoverManagerImpl.getFailoverManager(this, oracleDataSource);
        this.setFailoverManager(txnFailoverManagerImpl);
        this.originalUser = string;
        this.originalPasswd = string2;
    }

    @Override
    public void setSessionStateConsistency(boolean bl) throws SQLException {
        this.failoverMngr.setSessionStateConsistency(bl);
    }

    @Override
    public void beginRequest() throws SQLException {
        this.failoverMngr.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.failoverMngr.endRequest();
    }

    @Override
    public void disableReplay() throws SQLException {
        this.failoverMngr.disableReplay();
    }

    public ARRAY createARRAY(String string, Object object) throws SQLException {
        Object object2;
        Object object3;
        Object[] objectArray;
        if (object != null && object instanceof Object[]) {
            objectArray = (Object[])object;
            if (objectArray.length > 0) {
                object3 = new Object[objectArray.length];
                int n2 = 0;
                for (Object object4 : objectArray) {
                    object3[n2++] = object4 instanceof TxnReplayableBase ? ((TxnReplayableBase)object4).getDelegate() : object4;
                }
                object2 = object3;
            } else {
                object2 = object;
            }
        } else {
            object2 = object;
        }
        if (CREATEARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        objectArray = CREATEARRAY_METHOD;
        this.preForAll((Method)objectArray, this, string, object2);
        try {
            object3 = (OracleConnection)this.getDelegate();
            ARRAY aRRAY = object3.createARRAY(string, object2);
            return (ARRAY)this.postForAll((Method)objectArray, aRRAY);
        }
        catch (SQLException sQLException) {
            return (ARRAY)this.postForAll((Method)objectArray, this.onErrorForAll((Method)objectArray, sQLException));
        }
    }

    public Array createOracleArray(String string, Object object) throws SQLException {
        return this.createARRAY(string, object);
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof TxnReplayableBase ? ((TxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (CREATEARRAYOF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        Method method = CREATEARRAYOF_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Array array = connection.createArrayOf(string, objectArray2);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof TxnReplayableBase ? ((TxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (CREATESTRUCT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        Method method = CREATESTRUCT_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Struct struct = connection.createStruct(string, objectArray2);
            return (Struct)this.postForAll(method, struct);
        }
        catch (SQLException sQLException) {
            return (Struct)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }
}

