/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.authenticator;

import com.viettel.mmserver.base.ProcessThread;
import com.viettel.mmserver.database.ConnectionException;
import com.viettel.mmserver.database.DatabaseConnection;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.log4j.Logger;

public class ActionLogDbUtils
implements NotificationListener {
    private Logger logger;
    private Connection connection;
    private PreparedStatement insertLogReqStmt;
    private DbInstance dbInstance;
    private boolean sqlException;
    private static String actionLogId = "";
    private static String insertLogSql = "";
    private String schema = "";

    public ActionLogDbUtils(String logName) {
        try {
            this.logger = Logger.getLogger((String)logName);
            if (this.dbInstance == null) {
                this.dbInstance = new DbInstance("Action Log Thread");
            }
            this.dbInstance.start();
            this.schema = DatabaseConnection.shareInstance().getSchema();
            actionLogId = this.schema + ".ACTIONLOGID_SEQ.nextval";
            insertLogSql = "insert into " + this.schema + ".ACTIONLOG (LOGID" + ",USERNAME, APPLICATIONID, OPERATIONNAME, PARASTRING" + ", MBEANOBJECTNAME, RESULTSTRING, OPERATIONTIME" + ",OPERATIONYEAR, OPERATIONMONTH, OPERATIONDAY) VALUES (" + actionLogId + ",?,?,?,?,?,?,to_date(?,'yyyy/mm/dd/hh24/mi/ss'),?,?,?)";
            this.connection = DatabaseConnection.shareInstance().getConnection();
            this.connection.setAutoCommit(true);
            this.insertLogReqStmt = this.connection.prepareStatement(insertLogSql);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error in start ActionLogDbUtils");
            this.logger.error((Object)ex.toString());
        }
    }

    public int insertLog(String userName, String applicationId, String operationName, String paraString, String mBeanObjectName, String resultString, Calendar operationTime) {
        try {
            return this.iinsertLog(userName, applicationId, operationName, paraString, mBeanObjectName, resultString, operationTime);
        }
        catch (ConnectionException ce) {
            this.logger.info((Object)("connection exception:" + ce));
            this.logger.info((Object)"previous connection is closed, reconnect and retry again");
            try {
                return this.iinsertLog(userName, applicationId, operationName, paraString, mBeanObjectName, resultString, operationTime);
            }
            catch (ConnectionException e) {
                this.logger.info((Object)("connection exception:" + e));
                this.logger.info((Object)"can't create connection");
                return -1;
            }
        }
    }

    private int iinsertLog(String userName, String applicationId, String operationName, String paraString, String mBeanObjectName, String resultString, Calendar operationTime) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            this.insertLogReqStmt.clearParameters();
            this.insertLogReqStmt.setString(1, userName);
            this.insertLogReqStmt.setString(2, applicationId);
            this.insertLogReqStmt.setString(3, operationName);
            this.insertLogReqStmt.setString(4, paraString);
            this.insertLogReqStmt.setString(5, mBeanObjectName);
            this.insertLogReqStmt.setString(6, resultString);
            this.insertLogReqStmt.setString(7, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(new Date(operationTime.getTime().getTime())));
            this.insertLogReqStmt.setInt(8, operationTime.get(1));
            this.insertLogReqStmt.setInt(9, operationTime.get(2) + 1);
            this.insertLogReqStmt.setInt(10, operationTime.get(5));
            this.insertLogReqStmt.executeUpdate();
            return 0;
        }
        catch (SQLException ex) {
            if (DatabaseConnection.shareInstance().checkConnection()) {
                this.logger.debug((Object)("insert actionLog exception:" + ex));
                return ex.getErrorCode();
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
    }

    protected void updateConnection() {
        try {
            this.connection = DatabaseConnection.shareInstance().updateConnection();
            this.insertLogReqStmt = this.connection.prepareStatement(insertLogSql);
            this.sqlException = false;
        }
        catch (Exception ex) {
            this.logger.warn((Object)("connection error:" + ex));
            this.logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void handleNotification(Notification notification, Object handback) {
        this.dbInstance.add(notification);
    }

    class DbInstance
    extends ProcessThread {
        private List<Notification> waitQueue;

        public DbInstance(String threadName) {
            super(threadName);
            this.waitQueue = new ArrayList<Notification>();
        }

        protected void process() {
            Notification notification;
            if (this.waitQueue.size() > 0 && (notification = this.waitQueue.remove(0)).getType() != null && notification.getType().equals("method.invoke")) {
                String[] params;
                String identity = notification.getSource().toString();
                String message = notification.getMessage();
                if (message != null && !message.equals("") && (params = message.split("\\t")).length >= 6) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(Long.parseLong(params[5]));
                    ActionLogDbUtils.this.insertLog(identity, params[0], params[1], params[2], params[3], params[4], calendar);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.logger.info((Object)ex.toString());
            }
        }

        public void add(Notification notification) {
            if (notification != null) {
                this.waitQueue.add(notification);
            }
        }
    }
}

