/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.auth.MD5Token;
import org.jgroups.auth.SimpleToken;
import org.jgroups.protocols.AuthHeader;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=false)
public class AUTHTest {
    public static void testSimpleToken() {
        SimpleToken token1 = new SimpleToken();
        token1.setAuthValue("chris");
        SimpleToken token2 = new SimpleToken();
        token2.setAuthValue("chris");
        assert (token1.authenticate(token2, null));
    }

    public static void testSimpleTokenMismatch() {
        SimpleToken token1 = new SimpleToken();
        token1.setAuthValue("chris");
        SimpleToken token2 = new SimpleToken();
        token2.setAuthValue("chrismills");
        assert (!token1.authenticate(token2, null));
    }

    public static void testMD5Token() {
        MD5Token token1 = new MD5Token();
        token1.setAuthValue("chris");
        token1.setHashType("MD5");
        MD5Token token2 = new MD5Token();
        token2.setAuthValue("chris");
        token2.setHashType("MD5");
        assert (token1.authenticate(token2, null));
    }

    public static void testMD5TokenMismatch() {
        MD5Token token1 = new MD5Token();
        token1.setAuthValue("chris");
        token1.setHashType("MD5");
        MD5Token token2 = new MD5Token();
        token2.setAuthValue("chrismills");
        token2.setHashType("MD5");
        assert (!token1.authenticate(token2, null));
    }

    public static void testSHAToken() {
        MD5Token token1 = new MD5Token();
        token1.setAuthValue("chris");
        token1.setHashType("SHA");
        MD5Token token2 = new MD5Token();
        token2.setAuthValue("chris");
        token2.setHashType("SHA");
        assert (token1.authenticate(token2, null));
    }

    public static void testSHATokenMismatch() {
        MD5Token token1 = new MD5Token();
        token1.setAuthValue("chris");
        token1.setHashType("SHA");
        MD5Token token2 = new MD5Token();
        token2.setAuthValue("chrismills");
        token2.setHashType("SHA");
        assert (!token1.authenticate(token2, null));
    }

    public static void testAuthHeader() {
        SimpleToken token1 = new SimpleToken();
        token1.setAuthValue("chris");
        AuthHeader header = new AuthHeader();
        header.setToken(token1);
        assert (token1 == header.getToken());
    }

    public static void testAuthHeaderDifferent() {
        SimpleToken token1 = new SimpleToken();
        token1.setAuthValue("chris");
        SimpleToken token2 = new SimpleToken();
        token2.setAuthValue("chris");
        AuthHeader header = new AuthHeader();
        header.setToken(token1);
        assert (token2 != header.getToken());
    }
}

