/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;

public class Topology
extends Frame
implements WindowListener,
MembershipListener {
    private final Vector members = new Vector();
    private final Font myFont;
    private final FontMetrics fm;
    private final Color node_color = new Color(250, 220, 100);
    private boolean coordinator = false;
    private static final int NormalStyle = 0;
    private static final int CheckStyle = 1;
    private Channel channel;
    private Object my_addr = null;
    private static final String channel_name = "FD-Heartbeat";

    public Topology() {
        this.addWindowListener(this);
        this.fm = this.getFontMetrics(new Font("Helvetica", 0, 12));
        this.myFont = new Font("Helvetica", 0, 12);
    }

    public void addNode(Object member) {
        for (int i = 0; i < this.members.size(); ++i) {
            Object tmp = this.members.elementAt(i);
            if (!member.equals(tmp)) continue;
            return;
        }
        this.members.addElement(member);
        this.repaint();
    }

    public void removeNode(Object member) {
        for (int i = 0; i < this.members.size(); ++i) {
            Object tmp = this.members.elementAt(i);
            if (!member.equals(tmp)) continue;
            this.members.removeElement(this.members.elementAt(i));
            break;
        }
        this.repaint();
    }

    public void drawNode(Graphics g, int x, int y, String label, int style) {
        Color old = g.getColor();
        int width = this.fm.stringWidth(label) + 10;
        int height = this.fm.getHeight() + 5;
        g.setColor(this.node_color);
        g.fillRect(x, y, width, height);
        g.setColor(old);
        g.drawString(label, x + 5, y + 15);
        g.drawRoundRect(x - 1, y - 1, width + 1, height + 1, 10, 10);
        if (style == 1) {
            g.drawRoundRect(x - 2, y - 2, width + 2, height + 2, 10, 10);
            g.drawRoundRect(x - 3, y - 3, width + 3, height + 3, 10, 10);
        }
    }

    public void drawTopology(Graphics g) {
        int x = 20;
        int y = 50;
        Dimension box = this.getSize();
        Color old = g.getColor();
        if (this.coordinator) {
            g.setColor(Color.cyan);
            g.fillRect(11, 31, box.width - 21, box.height - 61);
            g.setColor(old);
        }
        g.drawRect(10, 30, box.width - 20, box.height - 60);
        g.setFont(this.myFont);
        for (int i = 0; i < this.members.size(); ++i) {
            String label = this.members.elementAt(i).toString();
            this.drawNode(g, x, y, label, 0);
            y += 50;
        }
    }

    @Override
    public void paint(Graphics g) {
        this.drawTopology(g);
    }

    @Override
    public void viewAccepted(View view) {
        this.setState(view.getMembers());
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    public void setState(Vector mbrs) {
        this.members.removeAllElements();
        for (int i = 0; i < mbrs.size(); ++i) {
            this.addNode(mbrs.elementAt(i));
        }
        this.coordinator = mbrs.size() <= 1 || mbrs.size() > 1 && mbrs.elementAt(0).equals(this.my_addr);
        this.repaint();
    }

    public void coordinatorChosen() {
        this.coordinator = true;
        this.repaint();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.channel.close();
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void start() throws Exception {
        String props = "udp.xml";
        this.channel = new JChannel(props);
        this.channel.connect(channel_name);
        new PullPushAdapter((Transport)this.channel, this);
        this.my_addr = this.channel.getAddress();
        if (this.my_addr != null) {
            this.setTitle(this.my_addr.toString());
        }
        this.pack();
        this.show();
    }

    public static void main(String[] args) {
        try {
            Topology top = new Topology();
            top.setLayout(null);
            top.setSize(240, 507);
            top.start();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(0);
        }
    }
}

