/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jeptesting;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.nfunk.jep.JEP;
import org.nfunk.jeptesting.BugsTest;
import org.nfunk.jeptesting.ComplexTest;
import org.nfunk.jeptesting.JEPTest;
import org.nfunk.jeptesting.LogarithmTest;
import org.nfunk.jeptesting.NaturalLogarithmTest;

public class AllTests {
    public static void main(String[] args) {
        JEP parser = new JEP();
        String expr = "Content==\"(la|bk|hp) (hit|dk).*\" && Receiver==\"8[0-7]98\"";
        System.out.println("Starting CustFunc...");
        parser.addStandardFunctions();
        parser.addStandardConstants();
        parser.addVariable("Content", "la hit");
        parser.addVariable("Receiver", "8298");
        parser.parseExpression(expr);
        if (parser.hasError()) {
            System.out.println("Error while parsing");
            System.out.println(parser.getErrorInfo());
            return;
        }
        double value = parser.getValue();
        if (parser.hasError()) {
            System.out.println("Error during evaluation");
            System.out.println(parser.getErrorInfo());
            return;
        }
        System.out.println(expr + " = " + value);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("All JUnit Tests");
        suite.addTest((Test)new JEPTest("testParseExpression"));
        suite.addTestSuite(LogarithmTest.class);
        suite.addTestSuite(NaturalLogarithmTest.class);
        suite.addTestSuite(BugsTest.class);
        suite.addTestSuite(ComplexTest.class);
        return suite;
    }
}

