/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Range
extends PostfixMathCommand {
    public Range() {
        this.numberOfParameters = -1;
    }

    public Object genRange(double low, double inc, int steps) {
        Vector<Double> res = new Vector<Double>(steps);
        res.setSize(steps);
        for (int i = 0; i < steps; ++i) {
            res.set(i, new Double(low + inc * (double)i));
        }
        return res;
    }

    public void run(Stack inStack) throws ParseException {
        Object res;
        this.checkStack(inStack);
        if (this.curNumberOfParameters < 1) {
            throw new ParseException("Empty list");
        }
        if (this.curNumberOfParameters == 2) {
            Object lastObj = inStack.pop();
            Object firstObj = inStack.pop();
            double last = ((Number)lastObj).doubleValue();
            double first = ((Number)firstObj).doubleValue();
            double diff = last - first;
            int steps = 1 + (int)diff;
            res = this.genRange(first, 1.0, steps);
        } else if (this.curNumberOfParameters == 3) {
            Object incObj = inStack.pop();
            Object lastObj = inStack.pop();
            Object firstObj = inStack.pop();
            double inc = ((Number)incObj).doubleValue();
            double last = ((Number)lastObj).doubleValue();
            double first = ((Number)firstObj).doubleValue();
            double diff = (last - first) / inc;
            int steps = 1 + (int)diff;
            res = this.genRange(first, inc, steps);
        } else if (this.curNumberOfParameters == 4) {
            Object stepsObj = inStack.pop();
            Object lastObj = inStack.pop();
            Object firstObj = inStack.pop();
            int steps = ((Number)stepsObj).intValue();
            double last = ((Number)lastObj).doubleValue();
            double first = ((Number)firstObj).doubleValue();
            double inc = (last - first) / (double)(steps - 1);
            res = this.genRange(first, inc, steps);
        } else {
            throw new ParseException("Range:only a maximum of four arguments can be specified");
        }
        inStack.push(res);
    }
}

