/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.common;

import com.viettel.common.ViettelMsg;
import java.util.ArrayList;

public class ClientInfor {
    private String username;
    private String password;
    private ArrayList<String> ips = new ArrayList();

    public ClientInfor() {
    }

    public ClientInfor(String username, String password, String[] ips) {
        this();
        this.username = username;
        this.password = password;
        this.setIps(ips);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIps() {
        ClientInfor clientInfor = this;
        synchronized (clientInfor) {
            return this.ips.toArray(new String[this.ips.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIps(String[] ips) {
        ClientInfor clientInfor = this;
        synchronized (clientInfor) {
            if (ips != null) {
                for (String ip : ips) {
                    if (ip == null) continue;
                    this.ips.add(ip);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() {
        ClientInfor clientInfor = this;
        synchronized (clientInfor) {
            return this.password;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        ClientInfor clientInfor = this;
        synchronized (clientInfor) {
            this.password = password;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUsername() {
        ClientInfor clientInfor = this;
        synchronized (clientInfor) {
            return this.username;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsername(String username) {
        ClientInfor clientInfor = this;
        synchronized (clientInfor) {
            this.username = username;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(String username, String password, String ip, ViettelMsg response) {
        ClientInfor clientInfor = this;
        synchronized (clientInfor) {
            if (this.username == null || !this.username.equals(username)) {
                response.set("description", "The user is null or not exist in the system");
                return false;
            }
            if (this.password == null || !this.password.equals(password)) {
                response.set("description", "The password is null or invalid");
                return false;
            }
            if (ip == null || ip.split("\\.").length != 4) {
                response.set("description", "The ip is is invalid");
                return false;
            }
            String warningAccessDenied = "Access Denied! The ip " + ip + " is not in [";
            for (String theIp : this.ips) {
                if (theIp == null || theIp.split("\\.").length != 4) continue;
                warningAccessDenied = warningAccessDenied + ",";
                warningAccessDenied = warningAccessDenied + theIp;
                if (!this.checkIp(ip.split("\\."), theIp.split("\\."))) continue;
                response.set("description", "Successfull!");
                return true;
            }
            warningAccessDenied = warningAccessDenied.replaceFirst(",", "");
            warningAccessDenied = warningAccessDenied + "]";
            response.set("description", warningAccessDenied);
            return false;
        }
    }

    private boolean checkIp(String[] clientIp, String[] configIp) {
        for (int i = 0; i < 4; ++i) {
            if ("*".equals(configIp[i]) || configIp[i].equals(clientIp[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[username:");
        buffer.append(this.username);
        buffer.append(",password:");
        buffer.append(this.password);
        buffer.append(",ip:");
        buffer.append(this.ips);
        buffer.append(']');
        return buffer.toString();
    }
}

