/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.common;

import com.viettel.common.ViettelChannel;
import com.viettel.common.ViettelChannelHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.log4j.Logger;
import utils.AgentMX;

public abstract class AbstractViettelChannel
extends AgentMX
implements ViettelChannel {
    private static long CHANNEL_ID = 0L;
    public static final String AUTHEN_SUCCESS = "0";
    public static final String AUTHEN_FAILURE = "1";
    protected final Set<ViettelChannelHandler> handlers = Collections.synchronizedSet(new HashSet());
    protected Logger logger;
    protected boolean sslSupport;
    protected long channelId;
    protected long receiverTimeout = 60000L;
    protected Object lock = new Object();
    protected long reqSend;
    protected long sent;
    protected long received;
    protected int channelType;
    protected boolean connected;
    protected boolean logged;

    private static final synchronized long getChannelIds() {
        CHANNEL_ID = AbstractViettelChannel.increase(CHANNEL_ID, 1L);
        return CHANNEL_ID;
    }

    public AbstractViettelChannel() {
        this.channelId = AbstractViettelChannel.getChannelIds();
    }

    protected static long increase(long value, long increase) {
        if (Long.MAX_VALUE - increase <= value) {
            return 0L;
        }
        return value + increase;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public void addHandler(ViettelChannelHandler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(ViettelChannelHandler handler) {
        this.handlers.remove(handler);
    }

    public void setChannelType(int channelType) {
        this.channelType = channelType;
    }

    public int getChannelType() {
        return this.channelType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogger(Logger logger) {
        Object object = this.lock;
        synchronized (object) {
            this.logger = logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void debug(String str) {
        Object object = this.lock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.debug((Object)str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void info(String str) {
        Object object = this.lock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.info((Object)str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void warn(String str) {
        Object object = this.lock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.warn((Object)str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(String str) {
        Object object = this.lock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.error((Object)str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(String str, Throwable ex) {
        Object object = this.lock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.error((Object)str, ex);
            }
        }
    }

    public void setReceiverTimeout(long timeout) {
        this.receiverTimeout = timeout;
    }

    public long getReceiverTimeout() {
        return this.receiverTimeout;
    }

    public long getChannelId() {
        return this.channelId;
    }

    public boolean isSslSupport() {
        return this.sslSupport;
    }

    public void setSslSupport(boolean val) {
        this.sslSupport = val;
    }

    public long getReceivedMessage() {
        return this.received;
    }

    public long getRequestMesssage() {
        return this.reqSend;
    }

    public long getSentMessage() {
        return this.sent;
    }

    public void registerAgent(String objName) {
        objName = objName + "-" + this.getChannelId();
        try {
            super.registerAgent(objName);
        }
        catch (MalformedObjectNameException ex) {
            this.error("register service agent error");
            this.error("exception:" + ex.toString());
        }
        catch (InstanceAlreadyExistsException ex) {
            this.error("register service agent error");
            this.error("exception:" + ex.toString());
        }
        catch (MBeanRegistrationException ex) {
            this.error("register service agent error");
            this.error("exception:" + ex.toString());
        }
        catch (NotCompliantMBeanException ex) {
            this.error("register service agent error");
            this.error("exception:" + ex.toString());
        }
    }

    public void unregisterAgent(String objName) {
        objName = objName + "-" + this.getChannelId();
        try {
            super.unregisterAgent(objName);
        }
        catch (MalformedObjectNameException ex) {
            this.info("unregister agent error");
            this.error("exception:" + ex.toString());
        }
        catch (InstanceNotFoundException ex) {
            this.info("unregister agent error");
            this.error("exception:" + ex.toString());
        }
        catch (MBeanRegistrationException ex) {
            this.info("unregister agent error");
            this.error("exception:" + ex.toString());
        }
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("connect")) {
            try {
                this.connect();
            }
            catch (IOException ex) {
                throw new MBeanException(ex);
            }
            return null;
        }
        if (operationName.equals("disconnect")) {
            try {
                this.disconnect();
            }
            catch (IOException ex) {
                throw new MBeanException(ex);
            }
            return null;
        }
        return super.invoke(operationName, params, signature);
    }

    protected MBeanOperationInfo[] buildOperations() {
        ArrayList<MBeanOperationInfo> v = new ArrayList<MBeanOperationInfo>();
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        v.add(new MBeanOperationInfo("connect", "connect channel", params, "void", 1));
        v.add(new MBeanOperationInfo("disconnect", "disconnect channel", params, "void", 1));
        v.add(new MBeanOperationInfo("getInfor", "get channel information", params, "java.lang.String", 0));
        return v.toArray(new MBeanOperationInfo[v.size()]);
    }
}

