/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.tcttaglib.newtag;

import com.viettel.tcttaglib.newtag.VTScrollTableHtmlTableWriter;
import com.viettel.tcttaglib.newtag.VTScrollTableSmartListHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.NumberUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.LongRange;
import org.apache.commons.lang.math.Range;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.ExportException;
import org.displaytag.exception.FactoryInstantiationException;
import org.displaytag.exception.InvalidTagAttributeValueException;
import org.displaytag.exception.WrappedRuntimeException;
import org.displaytag.export.BinaryExportView;
import org.displaytag.export.ExportView;
import org.displaytag.export.ExportViewFactory;
import org.displaytag.export.TextExportView;
import org.displaytag.model.Cell;
import org.displaytag.model.Column;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.pagination.PaginatedListSmartListHelper;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.tags.CaptionTag;
import org.displaytag.tags.TableTag;
import org.displaytag.util.CollectionUtil;
import org.displaytag.util.DependencyChecker;
import org.displaytag.util.Href;
import org.displaytag.util.ParamEncoder;
import org.displaytag.util.RequestHelper;
import org.displaytag.util.RequestHelperFactory;

public class VTScrollTableTag
extends TableTag {
    public static final String PAGE_ATTRIBUTE_MEDIA = "mediaType";
    public static final String FILTER_CONTENT_OVERRIDE_BODY = "org.displaytag.filter.ResponseOverrideFilter.CONTENT_OVERRIDE_BODY";
    private static final long serialVersionUID = 899149338534L;
    private static Log log = LogFactory.getLog(TableTag.class);
    private static RequestHelperFactory rhf;
    protected Object list;
    protected Object listAttribute;
    private int rowNumber = 1;
    private String name;
    private int length;
    private String decoratorName;
    private int pagesize;
    private boolean partialList;
    private boolean export;
    private int offset;
    private Object size;
    private String sizeObjectName;
    private Boolean sortFullTable;
    private boolean localSort = true;
    private String requestUri;
    private boolean dontAppendContext;
    private int defaultSortedColumn = -1;
    private SortOrderEnum defaultSortOrder;
    private String excludedParams;
    private String uid;
    private String varTotals;
    private TableModel tableModel;
    private Row currentRow;
    private VTScrollTableSmartListHelper listHelper;
    private Href baseHref;
    private TableProperties properties;
    private int pageNumber = 1;
    private Iterator tableIterator;
    private MediaTypeEnum currentMediaType;
    private boolean doAfterBodyExecuted;
    private ParamEncoder paramEncoder;
    private String footer;
    private boolean lastIteration;
    private String caption;
    private CaptionTag captionTag;
    private Object filteredRows;
    private PaginatedList paginatedList;
    private String targets;
    private Long height;
    private String callback;
    private String waitTime;
    private String columnDataType;

    public Long getHeight() {
        return this.height;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    public String getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(String waitTime) {
        this.waitTime = waitTime;
    }

    public void setTargets(String value) {
        this.targets = value;
    }

    public String getTargets() {
        return this.targets;
    }

    protected boolean isLastIteration() {
        return this.lastIteration;
    }

    public void setExcludedParams(String value) {
        this.excludedParams = value;
    }

    public void setFooter(String string) {
        this.footer = string;
        this.tableModel.setFooter(this.footer);
    }

    public void setCaption(String string) {
        this.caption = string;
        this.tableModel.setCaption(this.caption);
    }

    public void setCaptionTag(CaptionTag captionTag) {
        this.captionTag = captionTag;
    }

    public CaptionTag getCaptionTag() {
        return this.captionTag;
    }

    protected boolean isEmpty() {
        return this.currentRow == null;
    }

    public void setSize(Object size) {
        if (size instanceof String) {
            this.sizeObjectName = (String)size;
        } else {
            this.size = size;
        }
    }

    public void setSizeObjectName(String sizeObjectName) {
        this.sizeObjectName = sizeObjectName;
    }

    public void setSort(String value) throws InvalidTagAttributeValueException {
        if ("page".equals(value)) {
            this.sortFullTable = Boolean.FALSE;
        } else if ("list".equals(value)) {
            this.sortFullTable = Boolean.TRUE;
        } else if ("external".equals(value)) {
            this.localSort = false;
        } else {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "sort", (Object)value);
        }
    }

    public void setRequestURI(String value) {
        this.requestUri = value;
    }

    public void setRequestURIcontext(boolean value) {
        this.dontAppendContext = !value;
    }

    public void setList(Object value) {
        this.listAttribute = value;
    }

    public void setName(Object value) {
        if (value instanceof String) {
            this.name = (String)value;
        } else {
            this.list = value;
        }
    }

    public void setNameString(String value) {
        this.name = value;
    }

    public void setDefaultorder(String value) throws InvalidTagAttributeValueException {
        this.defaultSortOrder = SortOrderEnum.fromName((String)value);
        if (this.defaultSortOrder == null) {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "defaultorder", (Object)value);
        }
    }

    public void setDecorator(String decorator) {
        this.decoratorName = decorator;
    }

    public void setExport(boolean value) {
        this.export = value;
    }

    public void setVarTotals(String varTotalsName) {
        this.varTotals = varTotalsName;
    }

    public String getVarTotals() {
        return this.varTotals;
    }

    public void setLength(int value) {
        this.length = value;
    }

    public void setDefaultsort(int value) {
        this.defaultSortedColumn = value - 1;
    }

    public void setPagesize(int value) {
        this.pagesize = value;
    }

    public void setPartialList(boolean partialList) {
        this.partialList = partialList;
    }

    public void setOffset(int value) {
        this.offset = value < 1 ? 0 : value - 1;
    }

    public void setUid(String value) {
        this.uid = value;
    }

    public String getUid() {
        return this.uid;
    }

    protected TableProperties getProperties() {
        return this.properties;
    }

    protected Href getBaseHref() {
        return this.baseHref;
    }

    public void addColumn(HeaderCell column) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] addColumn " + column));
        }
        if (this.paginatedList != null && column.getSortable()) {
            String sortCriterion = this.paginatedList.getSortCriterion();
            String sortProperty = column.getSortProperty();
            if (sortProperty == null) {
                sortProperty = column.getBeanPropertyName();
            }
            if (sortCriterion != null && sortCriterion.equals(sortProperty)) {
                this.tableModel.setSortedColumnNumber(this.tableModel.getNumberOfColumns());
                column.setAlreadySorted();
            }
        }
        this.tableModel.addColumnHeader(column);
    }

    public void addCell(Cell cell) {
        if (this.currentRow != null) {
            int columnNumber = this.currentRow.getCellList().size();
            this.currentRow.addCell(cell);
            if (columnNumber < this.tableModel.getHeaderCellList().size()) {
                HeaderCell header = (HeaderCell)this.tableModel.getHeaderCellList().get(columnNumber);
                header.addCell(new Column(header, cell, this.currentRow));
            }
        }
    }

    protected boolean isFirstIteration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] first iteration=" + (this.rowNumber == 1) + " (row number=" + this.rowNumber + ")"));
        }
        return this.rowNumber == 1;
    }

    public int doStartTag() throws JspException {
        DependencyChecker.check();
        ExportViewFactory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doStartTag called"));
        }
        this.properties = TableProperties.getInstance((HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest()));
        this.tableModel = new TableModel(this.properties, this.pageContext.getResponse().getCharacterEncoding(), this.pageContext);
        this.tableModel.setId(this.getUid());
        this.initParameters();
        this.tableModel.setMedia(this.currentMediaType);
        Object previousMediaType = this.pageContext.getAttribute(PAGE_ATTRIBUTE_MEDIA);
        if (previousMediaType == null || MediaTypeEnum.HTML.equals(previousMediaType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getUid() + "] setting media [" + this.currentMediaType + "] in this.pageContext"));
            }
            this.pageContext.setAttribute(PAGE_ATTRIBUTE_MEDIA, (Object)this.currentMediaType);
        }
        this.doIteration();
        return 2;
    }

    public int doAfterBody() {
        this.doAfterBodyExecuted = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doAfterBody called - iterating on row " + this.rowNumber));
        }
        ++this.rowNumber;
        return this.doIteration();
    }

    protected int doIteration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doIteration called"));
        }
        if (this.currentRow != null) {
            this.tableModel.addRow(this.currentRow);
            this.currentRow = null;
        }
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            if (this.getUid() != null) {
                if (iteratedObject != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[" + this.getUid() + "] setting attribute \"" + this.getUid() + "\" in pageContext"));
                    }
                    this.pageContext.setAttribute(this.getUid(), iteratedObject);
                } else {
                    this.pageContext.removeAttribute(this.getUid());
                }
                this.pageContext.setAttribute(this.getUid() + "_rowNum", (Object)new Integer(this.rowNumber));
            }
            this.currentRow = new Row(iteratedObject, this.rowNumber);
            this.lastIteration = !this.tableIterator.hasNext();
            return 2;
        }
        this.lastIteration = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doIteration() - iterator ended after " + (this.rowNumber - 1) + " rows"));
        }
        return 0;
    }

    private void initParameters() throws JspTagException, FactoryInstantiationException {
        boolean wishOptimizedIteration;
        String fullName;
        if (rhf == null) {
            rhf = this.properties.getRequestHelperFactoryInstance();
        }
        if ((fullName = this.getFullObjectName()) != null) {
            this.list = this.evaluateExpression(fullName);
        } else if (this.list == null) {
            this.list = this.listAttribute;
        }
        if (this.list instanceof PaginatedList) {
            this.paginatedList = (PaginatedList)this.list;
            this.list = this.paginatedList.getList();
        }
        this.tableModel.setLocalSort(this.localSort && this.paginatedList == null);
        RequestHelper requestHelper = rhf.getRequestHelperInstance(this.pageContext);
        this.initHref(requestHelper);
        Integer pageNumberParameter = requestHelper.getIntParameter(this.encodeParameter("p"));
        this.pageNumber = pageNumberParameter == null ? 1 : pageNumberParameter;
        int sortColumn = -1;
        if (!this.tableModel.isLocalSort()) {
            String sortColumnName = requestHelper.getParameter(this.encodeParameter("s"));
            String usename = requestHelper.getParameter(this.encodeParameter("n"));
            if (sortColumnName == null) {
                this.tableModel.setSortedColumnNumber(this.defaultSortedColumn);
            } else if (usename != null) {
                this.tableModel.setSortedColumnName(sortColumnName);
            } else if (NumberUtils.isNumber((String)sortColumnName)) {
                sortColumn = Integer.parseInt(sortColumnName);
                this.tableModel.setSortedColumnNumber(sortColumn);
            }
        } else if (this.paginatedList == null) {
            Integer sortColumnParameter = requestHelper.getIntParameter(this.encodeParameter("s"));
            sortColumn = sortColumnParameter == null ? this.defaultSortedColumn : sortColumnParameter;
            this.tableModel.setSortedColumnNumber(sortColumn);
        } else {
            sortColumn = this.defaultSortedColumn;
        }
        boolean finalSortFull = this.properties.getSortFullList();
        if (this.sortFullTable != null) {
            finalSortFull = this.sortFullTable;
        }
        if (!this.partialList || !finalSortFull) {
            this.tableModel.setSortFullTable(finalSortFull);
        }
        if (this.paginatedList == null) {
            SortOrderEnum paramOrder = SortOrderEnum.fromCode((Integer)requestHelper.getIntParameter(this.encodeParameter("o")));
            if (paramOrder == null) {
                paramOrder = this.defaultSortOrder;
            }
            boolean order = SortOrderEnum.DESCENDING != paramOrder;
            this.tableModel.setSortOrderAscending(order);
        } else {
            SortOrderEnum direction = this.paginatedList.getSortDirection();
            this.tableModel.setSortOrderAscending(direction == SortOrderEnum.ASCENDING);
        }
        Integer exportTypeParameter = requestHelper.getIntParameter(this.encodeParameter("e"));
        this.currentMediaType = (MediaTypeEnum)ObjectUtils.defaultIfNull((Object)MediaTypeEnum.fromCode((Integer)exportTypeParameter), (Object)MediaTypeEnum.HTML);
        if (this.partialList) {
            if (this.sizeObjectName != null || this.size == null) {
                // empty if block
            }
            if (this.sizeObjectName != null) {
                this.size = this.evaluateExpression(this.sizeObjectName);
            }
            if (this.size == null) {
                throw new JspTagException(Messages.getString((String)"MissingAttributeException.msg", (Object[])new Object[]{"size"}));
            }
            if (!(this.size instanceof Integer)) {
                throw new JspTagException(Messages.getString((String)"InvalidTypeException.msg", (Object[])new Object[]{"size", "Integer"}));
            }
        }
        boolean bl = wishOptimizedIteration = (this.pagesize > 0 || this.offset > 0 || this.length > 0) && !this.partialList;
        if (!(!wishOptimizedIteration || !(this.list instanceof Collection) || sortColumn != -1 && finalSortFull || this.currentMediaType != MediaTypeEnum.HTML && this.properties.getExportFullList())) {
            int start = 0;
            int end = 0;
            if (this.offset > 0) {
                start = this.offset;
            }
            if (this.length > 0) {
                end = start + this.length;
            }
            if (this.pagesize > 0) {
                start = (this.pageNumber - 1) * this.pagesize;
                int fullSize = ((Collection)this.list).size();
                if (start > fullSize) {
                    int div = fullSize / this.pagesize;
                    start = fullSize % this.pagesize == 0 ? div : div + 1;
                }
                end = start + this.pagesize;
            }
            this.filteredRows = new LongRange((long)(start + 1), (long)end);
        } else {
            this.filteredRows = new LongRange(1L, Long.MAX_VALUE);
        }
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
    }

    protected boolean isIncludedRow() {
        return ((Range)this.filteredRows).containsLong((long)this.rowNumber);
    }

    private String getFullObjectName() {
        if (this.name == null) {
            return null;
        }
        return this.name;
    }

    protected void initHref(RequestHelper requestHelper) {
        System.out.println("OK in initHref");
        this.baseHref = requestHelper.getHref();
        if (this.excludedParams != null) {
            String[] splittedExcludedParams = StringUtils.split((String)this.excludedParams);
            if (splittedExcludedParams.length == 1 && "*".equals(splittedExcludedParams[0])) {
                if (this.paramEncoder == null) {
                    this.paramEncoder = new ParamEncoder(this.getUid());
                }
                for (String key : this.baseHref.getParameterMap().keySet()) {
                    if (this.paramEncoder.isParameterEncoded(key)) continue;
                    this.baseHref.removeParameter(key);
                }
            } else {
                for (int j = 0; j < splittedExcludedParams.length; ++j) {
                    this.baseHref.removeParameter(splittedExcludedParams[j]);
                }
            }
        }
        if (this.requestUri != null) {
            String contextPath;
            String fullURI = this.requestUri;
            if (!this.dontAppendContext && !StringUtils.isEmpty((String)(contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath())) && this.requestUri != null && this.requestUri.startsWith("/") && !this.requestUri.startsWith(contextPath)) {
                fullURI = contextPath + this.requestUri;
            }
            fullURI = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(fullURI);
            this.baseHref.setFullUrl(fullURI);
            System.out.println("fullURI" + fullURI);
        }
    }

    public int doEndTag() throws JspException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doEndTag called"));
        }
        if (!this.doAfterBodyExecuted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getUid() + "] tag body is empty."));
            }
            if (this.currentRow != null) {
                this.tableModel.addRow(this.currentRow);
            }
            while (this.tableIterator.hasNext()) {
                Object iteratedObject = this.tableIterator.next();
                ++this.rowNumber;
                this.currentRow = new Row(iteratedObject, this.rowNumber);
                this.tableModel.addRow(this.currentRow);
            }
        }
        if (this.tableModel.isEmpty()) {
            this.describeEmptyTable();
        }
        String tableDecoratorName = null;
        Object previousMediaType = this.pageContext.getAttribute(PAGE_ATTRIBUTE_MEDIA);
        if (MediaTypeEnum.HTML.equals((Object)this.currentMediaType) && (previousMediaType == null || MediaTypeEnum.HTML.equals(previousMediaType))) {
            tableDecoratorName = this.decoratorName;
        } else if (!MediaTypeEnum.HTML.equals((Object)this.currentMediaType)) {
            tableDecoratorName = this.properties.getExportDecoratorName(this.currentMediaType);
        }
        TableDecorator tableDecorator = this.properties.getDecoratorFactoryInstance().loadTableDecorator(this.pageContext, tableDecoratorName);
        if (tableDecorator != null) {
            tableDecorator.init(this.pageContext, this.list, this.tableModel);
            this.tableModel.setTableDecorator(tableDecorator);
        }
        this.setupViewableData();
        if (this.paginatedList == null && this.tableModel.isLocalSort() && !this.tableModel.isSortFullTable()) {
            this.tableModel.sortPageList();
        }
        int returnValue = 6;
        if (MediaTypeEnum.HTML.equals((Object)this.currentMediaType) && (previousMediaType == null || MediaTypeEnum.HTML.equals(previousMediaType))) {
            this.writeHTMLData();
        } else if (!MediaTypeEnum.HTML.equals((Object)this.currentMediaType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getUid() + "] doEndTag - exporting"));
            }
            returnValue = this.doExport();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] doEndTag - end"));
        }
        this.cleanUp();
        return returnValue;
    }

    private void cleanUp() {
        this.currentMediaType = null;
        this.baseHref = null;
        this.caption = null;
        this.captionTag = null;
        this.currentRow = null;
        this.doAfterBodyExecuted = false;
        this.footer = null;
        this.listHelper = null;
        this.pageNumber = 0;
        this.paramEncoder = null;
        this.properties = null;
        this.rowNumber = 1;
        this.tableIterator = null;
        this.tableModel = null;
        this.list = null;
    }

    private void describeEmptyTable() {
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            Map objectProperties = new HashMap();
            if (iteratedObject instanceof String) {
                return;
            }
            if (iteratedObject instanceof Map) {
                objectProperties = (Map)iteratedObject;
            } else {
                try {
                    objectProperties = BeanUtils.describe(iteratedObject);
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to automatically add columns: " + e.getMessage()), (Throwable)e);
                }
            }
            for (String propertyName : objectProperties.keySet()) {
                if ("class".equals(propertyName)) continue;
                HeaderCell headerCell = new HeaderCell();
                headerCell.setBeanPropertyName(propertyName);
                headerCell.setTitle(this.properties.geResourceProvider().getResource(null, propertyName, (Tag)this, this.pageContext));
                this.tableModel.addColumnHeader(headerCell);
            }
        }
    }

    protected int doExport() throws JspException {
        boolean exportFullList = this.properties.getExportFullList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] currentMediaType=" + this.currentMediaType));
        }
        boolean exportHeader = this.properties.getExportHeader(this.currentMediaType);
        boolean exportDecorated = this.properties.getExportDecorated();
        ExportView exportView = ExportViewFactory.getInstance().getView(this.currentMediaType, this.tableModel, exportFullList, exportHeader, exportDecorated);
        try {
            this.writeExport(exportView);
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeExport(ExportView exportView) throws IOException, JspException {
        String characterEncoding;
        String mimeType;
        boolean usingFilter;
        HttpServletResponse response;
        String filename;
        block11: {
            filename = this.properties.getExportFileName(this.currentMediaType);
            response = (HttpServletResponse)this.pageContext.getResponse();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            Map bean = (Map)request.getAttribute(FILTER_CONTENT_OVERRIDE_BODY);
            usingFilter = bean != null;
            mimeType = exportView.getMimeType();
            characterEncoding = response.getCharacterEncoding();
            if (usingFilter) {
                if (!bean.containsKey("buffer")) {
                    log.debug((Object)"Exportfilter enabled in unbuffered mode, setting headers");
                    response.addHeader("6578706f7274", "");
                    break block11;
                } else {
                    bean.put("contenttype", mimeType);
                    bean.put("filename", filename);
                    if (exportView instanceof TextExportView) {
                        StringWriter writer = new StringWriter();
                        ((TextExportView)exportView).doExport((Writer)writer);
                        bean.put("body", writer.toString());
                        return;
                    }
                    if (!(exportView instanceof BinaryExportView)) throw new JspTagException("Export view " + exportView.getClass().getName() + " must implement TextExportView or BinaryExportView");
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    ((BinaryExportView)exportView).doExport((OutputStream)stream);
                    bean.put("body", stream.toByteArray());
                    return;
                }
            }
            log.debug((Object)"Exportfilter NOT enabled");
            if (response.isCommitted()) {
                throw new ExportException(((Object)((Object)this)).getClass());
            }
            try {
                response.reset();
                this.pageContext.getOut().clearBuffer();
            }
            catch (Exception e) {
                throw new ExportException(((Object)((Object)this)).getClass());
            }
        }
        if (!usingFilter && characterEncoding != null && mimeType.indexOf("charset") == -1) {
            mimeType = mimeType + "; charset=" + characterEncoding;
        }
        response.setContentType(mimeType);
        if (StringUtils.isNotEmpty((String)filename)) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        }
        if (exportView instanceof TextExportView) {
            PrintWriter writer = usingFilter ? response.getWriter() : this.pageContext.getOut();
            ((TextExportView)exportView).doExport((Writer)writer);
        } else {
            if (!(exportView instanceof BinaryExportView)) throw new JspTagException("Export view " + exportView.getClass().getName() + " must implement TextExportView or BinaryExportView");
            ((BinaryExportView)exportView).doExport((OutputStream)response.getOutputStream());
        }
        log.debug((Object)"Export completed");
    }

    protected void setupViewableData() {
        if ((this.paginatedList == null || this.tableModel.isLocalSort()) && this.tableModel.isSortFullTable()) {
            this.tableModel.sortFullList();
        }
        List originalData = this.tableModel.getRowListFull();
        List fullList = CollectionUtil.getListFromObject((Object)originalData, (int)this.offset, (int)this.length);
        int pageOffset = this.offset;
        if (this.paginatedList == null && this.pagesize > 0) {
            this.listHelper = new VTScrollTableSmartListHelper(fullList, this.partialList ? ((Integer)this.size).intValue() : fullList.size(), this.pagesize, this.properties, this.partialList);
            this.listHelper.setCurrentPage(this.pageNumber);
            pageOffset = this.listHelper.getFirstIndexForCurrentPage();
            fullList = this.listHelper.getListForCurrentPage();
        } else if (this.paginatedList != null) {
            PaginatedListSmartListHelper slh = new PaginatedListSmartListHelper(this.paginatedList, this.properties);
            this.listHelper = (VTScrollTableSmartListHelper)slh;
        }
        this.tableModel.setRowListPage(fullList);
        this.tableModel.setPageOffset(pageOffset);
    }

    protected void writeHTMLData() throws JspException {
        JspWriter out = this.pageContext.getOut();
        String css = this.properties.getCssTable();
        if (StringUtils.isNotBlank((String)css)) {
            this.addClass(css);
        }
        new VTScrollTableHtmlTableWriter(this.tableModel, this.properties, this.baseHref, this.export, out, this.getCaptionTag(), this.paginatedList, this.listHelper, this.pagesize, this.getAttributeMap(), this.uid, this.requestUri, this.targets, this.columnDataType, this.waitTime, this.callback).writeTable(this.tableModel, this.getUid(), this.getHeight());
        if (this.varTotals != null) {
            this.pageContext.setAttribute(this.varTotals, (Object)this.getTotals());
        }
    }

    public Map getTotals() {
        HashMap<String, Double> totalsMap = new HashMap<String, Double>();
        if (this.varTotals != null) {
            List headers = this.tableModel.getHeaderCellList();
            for (HeaderCell headerCell : headers) {
                if (!headerCell.isTotaled()) continue;
                totalsMap.put("column" + (headerCell.getColumnNumber() + 1), new Double(headerCell.getTotal()));
            }
        }
        return totalsMap;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public void release() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getUid() + "] release() called"));
        }
        super.release();
        this.decoratorName = null;
        this.defaultSortedColumn = -1;
        this.defaultSortOrder = null;
        this.export = false;
        this.length = 0;
        this.listAttribute = null;
        this.localSort = true;
        this.name = null;
        this.offset = 0;
        this.pagesize = 0;
        this.partialList = false;
        this.requestUri = null;
        this.dontAppendContext = false;
        this.sortFullTable = null;
        this.excludedParams = null;
        this.filteredRows = null;
        this.uid = null;
        this.paginatedList = null;
    }

    protected String getName() {
        return this.name;
    }

    private String encodeParameter(String parameterName) {
        if (this.paramEncoder == null) {
            this.paramEncoder = new ParamEncoder(this.getUid());
        }
        return this.paramEncoder.encodeParameterName(parameterName);
    }
}

