/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.tcttaglib.newtag;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.pagination.NumberedPage;
import org.displaytag.pagination.Pagination;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.Href;

public class VTScrollTablePagination
extends Pagination {
    private static Log log = LogFactory.getLog(Pagination.class);
    private Href href;
    private String pageParam;
    private Integer firstPage;
    private Integer lastPage;
    private Integer previousPage;
    private Integer nextPage;
    private Integer currentPage;
    private List pages = new ArrayList();
    private TableProperties properties;

    public VTScrollTablePagination(Href baseHref, String pageParameter, TableProperties properties) {
        super(baseHref, pageParameter, properties);
        this.href = baseHref;
        this.pageParam = pageParameter;
        this.properties = properties;
    }

    public void addPage(int number, boolean isSelected) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding page " + number));
        }
        this.pages.add(new NumberedPage(number, isSelected));
    }

    public boolean isFirst() {
        return this.firstPage == null;
    }

    public boolean isLast() {
        return this.lastPage == null;
    }

    public boolean isOnePage() {
        return this.pages == null || this.pages.size() <= 1;
    }

    public Integer getFirst() {
        return this.firstPage;
    }

    public void setFirst(Integer first) {
        this.firstPage = first;
    }

    public Integer getLast() {
        return this.lastPage;
    }

    public void setLast(Integer last) {
        this.lastPage = last;
    }

    public Integer getPrevious() {
        return this.previousPage;
    }

    public void setPrevious(Integer previous) {
        this.previousPage = previous;
    }

    public Integer getNext() {
        return this.nextPage;
    }

    public void setNext(Integer next) {
        this.nextPage = next;
    }

    public void setCurrent(Integer current) {
        this.currentPage = current;
    }

    public String getFormattedBanner(String numberedPageFormat, String numberedPageSelectedFormat, String numberedPageSeparator, String fullBanner, String requestUri) {
        StringBuffer buffer = new StringBuffer(100);
        Iterator pageIterator = this.pages.iterator();
        while (pageIterator.hasNext()) {
            NumberedPage page = (NumberedPage)pageIterator.next();
            Integer pageNumber = new Integer(page.getNumber());
            String urlString = ((Href)this.href.clone()).addParameter(this.pageParam, (Object)pageNumber).toString();
            urlString = requestUri.contains("?") ? requestUri + "&" + urlString.substring(1, urlString.length()) : requestUri + "?" + urlString.substring(1, urlString.length());
            Object[] pageObjects = new Object[]{pageNumber, urlString};
            if (page.getSelected()) {
                buffer.append(new MessageFormat(numberedPageSelectedFormat, this.properties.getLocale()).format(pageObjects));
            } else {
                buffer.append(new MessageFormat(numberedPageFormat, this.properties.getLocale()).format(pageObjects));
            }
            if (!pageIterator.hasNext()) continue;
            buffer.append(numberedPageSeparator);
        }
        String numberedPageString = buffer.toString();
        String sFirstUrl = ((Href)this.href.clone()).addParameter(this.pageParam, (Object)this.getFirst()).toString();
        sFirstUrl = requestUri.contains("?") ? "&" + sFirstUrl.substring(1, sFirstUrl.length()) : "?" + sFirstUrl.substring(1, sFirstUrl.length());
        String sPreviousUrl = ((Href)this.href.clone()).addParameter(this.pageParam, (Object)this.getPrevious()).toString();
        sPreviousUrl = requestUri.contains("?") ? "&" + sPreviousUrl.substring(1, sPreviousUrl.length()) : "?" + sPreviousUrl.substring(1, sPreviousUrl.length());
        String sNextUrl = ((Href)this.href.clone()).addParameter(this.pageParam, (Object)this.getNext()).toString();
        sNextUrl = requestUri.contains("?") ? "&" + sNextUrl.substring(1, sNextUrl.length()) : "?" + sNextUrl.substring(1, sNextUrl.length());
        String sLastUrl = ((Href)this.href.clone()).addParameter(this.pageParam, (Object)this.getLast()).toString();
        sLastUrl = requestUri.contains("?") ? "&" + sLastUrl.substring(1, sLastUrl.length()) : "?" + sLastUrl.substring(1, sLastUrl.length());
        Object[] pageObjects = new Object[]{numberedPageString, sFirstUrl, sPreviousUrl, sNextUrl, sLastUrl, this.currentPage, this.isLast() ? this.currentPage : this.lastPage};
        return MessageFormat.format(fullBanner, pageObjects);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("firstPage", (Object)this.firstPage).append("lastPage", (Object)this.lastPage).append("currentPage", (Object)this.currentPage).append("nextPage", (Object)this.nextPage).append("previousPage", (Object)this.previousPage).append("pages", (Object)this.pages).append("href", (Object)this.href).append("pageParam", (Object)this.pageParam).toString();
    }
}

