/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.framework.interceptor;

import com.viettel.common.util.ResourceBundleUtil;
import com.viettel.security.PassTranformer;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class BaseHibernateDAO {
    private static final Logger log = Logger.getLogger(BaseHibernateDAO.class);
    private static BaseHibernateDAO instance = new BaseHibernateDAO();
    public static final ThreadLocal<Session> localCurrentSession = new ThreadLocal();
    public static Configuration configuration = new Configuration();
    public static SessionFactory sessionFactory;
    public static String configFile;
    private static final Owner trueOwner;
    private static final Owner fakeOwner;

    private static void decryptDBConfig(Configuration dbConfig, String path) {
        if ("true".equals(dbConfig.getProperty("is_information_encrypted").toLowerCase())) {
            String[] propertiesToDecrypt = new String[]{"hibernate.connection.url", "hibernate.connection.username", "hibernate.connection.password", "connection.url", "connection.username", "connection.password"};
            for (int i = 0; i < propertiesToDecrypt.length; ++i) {
                if (dbConfig.getProperty(propertiesToDecrypt[i]) == null) continue;
                try {
                    dbConfig.setProperty(propertiesToDecrypt[i], PassTranformer.decrypt((String)dbConfig.getProperty(propertiesToDecrypt[i])));
                    continue;
                }
                catch (Throwable ex) {
                    log.error((Object)("L\u1ed7i gi\u1ea3i m\u00e3 thu\u1ed9c t\u00ednh \"" + propertiesToDecrypt[i] + "\" c\u1ee7a file" + path), ex);
                }
            }
        } else {
            log.info((Object)("File " + path + ": is_information_encrypted is null or false"));
        }
    }

    public static BaseHibernateDAO getInstance() {
        return instance;
    }

    public static Object createSession() throws Exception {
        Session session = localCurrentSession.get();
        if (session == null) {
            System.out.println("No Session Found - Create and give the identity");
            session = BaseHibernateDAO.getSessionFactory().openSession();
            localCurrentSession.set(session);
            return trueOwner;
        }
        System.out.println("Session Found - Give a Fake identity");
        return fakeOwner;
    }

    public static Session getSession() throws HibernateException {
        Session session = localCurrentSession.get();
        return session;
    }

    public static long getSequence(String sequenceName) throws Exception {
        String strQuery = "SELECT " + sequenceName + " .NextVal FROM Dual";
        SQLQuery queryObject = BaseHibernateDAO.getSession().createSQLQuery(strQuery);
        BigDecimal bigDecimal = (BigDecimal)queryObject.uniqueResult();
        return bigDecimal.longValue();
    }

    public static void closeSession(Object ownership) throws Exception {
        if (((Owner)ownership).identity) {
            System.out.println("Identity is accepted. Now closing the session");
            Session session = localCurrentSession.get();
            session.flush();
            session.close();
            localCurrentSession.set(null);
        } else {
            System.out.println("Identity is rejected. Ignoring the request");
        }
    }

    public static Session openThreadSession() throws HibernateException {
        Session session = localCurrentSession.get();
        if (session != null) {
            if (session.isOpen()) {
                try {
                    if (!session.connection().isClosed()) {
                        return session;
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            localCurrentSession.remove();
        }
        if (session == null || !session.isOpen()) {
            if (sessionFactory == null) {
                BaseHibernateDAO.rebuildSessionFactory();
            }
            session = sessionFactory != null ? sessionFactory.openSession() : null;
            localCurrentSession.set(session);
        }
        return session;
    }

    public static void rebuildSessionFactory() {
        try {
            configuration.configure(configFile);
            sessionFactory = configuration.buildSessionFactory();
        }
        catch (Exception e) {
            System.err.println("%%%% Error Creating SessionFactory %%%%");
            e.printStackTrace();
        }
    }

    public static void closeSession() throws HibernateException {
        Session session = localCurrentSession.get();
        localCurrentSession.set(null);
        if (session != null && session.isOpen()) {
            session.close();
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static void setConfigFile(String configFile) {
        BaseHibernateDAO.configFile = configFile;
        sessionFactory = null;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    static {
        configFile = "";
        trueOwner = new Owner(true);
        fakeOwner = new Owner(false);
        try {
            configFile = ResourceBundleUtil.getHibernateConfigFileLocation();
            configuration.configure(configFile);
            BaseHibernateDAO.decryptDBConfig(configuration, configFile);
            sessionFactory = configuration.buildSessionFactory();
        }
        catch (Exception e) {
            System.err.println("Loi trong khi khoi tao SessionFactory");
            e.printStackTrace();
        }
    }

    private static class Owner {
        boolean identity = false;

        public Owner(boolean identity) {
            this.identity = identity;
        }
    }
}

