/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.database.DAO;

import com.opensymphony.xwork2.ActionSupport;
import com.viettel.common.util.ArgChecker;
import com.viettel.database.BO.BasicBO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDAOMDBAction
extends ActionSupport {
    private HashMap<String, Session> sessions = new HashMap();
    private Exception exception;

    public Session getSession() {
        return this.getSession("default session");
    }

    public Session getSession(String key) {
        if (this.sessions.size() == 0) {
            System.out.println("Khong co session voi key la " + key);
            return null;
        }
        Session s = this.sessions.get(key.toLowerCase());
        if (s == null) {
            System.out.println("Session ung voi key " + key + " khong ton tai trong DBCConfig.");
            return null;
        }
        s.beginTransaction();
        return s;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public HashMap<String, Session> getSessions() {
        return this.sessions;
    }

    public void setSessions(HashMap<String, Session> sessions) {
        this.sessions = sessions;
    }

    public void save(BasicBO objectToSave) throws Exception {
        Session session = this.sessions.get("default session");
        ArgChecker.denyNull(objectToSave);
        session.save((Object)objectToSave);
    }

    public void update(BasicBO objectToUpdate) throws Exception {
        Session session = this.sessions.get("default session");
        ArgChecker.denyNull(objectToUpdate);
        session.update((Object)objectToUpdate);
    }

    public void saveOrUpdate(BasicBO objectToSaveOrUpdate) throws Exception {
        Session session = this.sessions.get("default session");
        ArgChecker.denyNull(objectToSaveOrUpdate);
        session.saveOrUpdate((Object)objectToSaveOrUpdate);
    }

    public void delete(BasicBO objectToDelete) throws Exception {
        Session session = this.sessions.get("default session");
        ArgChecker.denyNull(objectToDelete);
        session.delete((Object)objectToDelete);
    }

    public void refresh(BasicBO objectToRefresh) throws Exception {
        Session session = this.sessions.get("default session");
        session.refresh((Object)objectToRefresh);
    }

    public BasicBO get(Object id, String strClassHandle) throws Exception {
        Session session = this.sessions.get("default session");
        BasicBO instance = (BasicBO)session.get(strClassHandle, (Serializable)id);
        if (instance != null) {
            session.refresh((Object)instance);
        }
        return instance;
    }

    public BasicBO read(String strClassHandle, String idName, Object id) throws Exception {
        Session session = this.sessions.get("default session");
        List lstObj = session.createCriteria(strClassHandle).add((Criterion)Restrictions.eq((String)idName, (Object)id)).list();
        BasicBO obj = null;
        if (lstObj.size() > 0) {
            obj = (BasicBO)((BasicBO)lstObj.get(0)).clone();
        }
        return obj;
    }

    public List getAll(String strClassHandle) {
        Session session = this.sessions.get("default session");
        String queryString = "from " + strClassHandle;
        Query queryObject = session.createQuery(queryString);
        return queryObject.list();
    }

    public List findByProperty(String strClassHandle, String propertyName, Object value) {
        List lstReturn = new ArrayList();
        String queryString = "from " + strClassHandle + " as model where model." + propertyName + "= ?";
        Query queryObject = this.sessions.get("default session").createQuery(queryString);
        queryObject.setParameter(0, value);
        lstReturn = queryObject.list();
        return lstReturn;
    }

    public List findByProperty(String strClassHandle, String propertyName, Object value, String orderClause) {
        List lstReturn = new ArrayList();
        String queryString = "from " + strClassHandle + " as model where model." + propertyName + "= ? " + orderClause;
        Query queryObject = this.sessions.get("default session").createQuery(queryString);
        queryObject.setParameter(0, value);
        lstReturn = queryObject.list();
        return lstReturn;
    }

    public long getSequence(String sequenceName) throws Exception {
        String strQuery = "SELECT " + sequenceName + " .NextVal FROM Dual";
        SQLQuery queryObject = this.sessions.get("default session").createSQLQuery(strQuery);
        BigDecimal bigDecimal = (BigDecimal)queryObject.uniqueResult();
        return bigDecimal.longValue();
    }

    public Date getSysdate() throws Exception {
        String strQuery = "SELECT sysdate as system_datetime FROM Dual";
        SQLQuery queryObject = this.sessions.get("default session").createSQLQuery(strQuery);
        queryObject.addScalar("system_datetime", (Type)Hibernate.TIMESTAMP);
        Date sysdate = (Date)queryObject.uniqueResult();
        return sysdate;
    }

    public void save(BasicBO objectToSave, String sessionName) throws Exception {
        Session session = this.sessions.get(sessionName);
        ArgChecker.denyNull(objectToSave);
        session.save((Object)objectToSave);
    }

    public void update(BasicBO objectToUpdate, String sessionName) throws Exception {
        Session session = this.sessions.get(sessionName);
        ArgChecker.denyNull(objectToUpdate);
        session.update((Object)objectToUpdate);
    }

    public void saveOrUpdate(BasicBO objectToSaveOrUpdate, String sessionName) throws Exception {
        Session session = this.sessions.get(sessionName);
        ArgChecker.denyNull(objectToSaveOrUpdate);
        session.saveOrUpdate((Object)objectToSaveOrUpdate);
    }

    public void delete(BasicBO objectToDelete, String sessionName) throws Exception {
        Session session = this.sessions.get(sessionName);
        ArgChecker.denyNull(objectToDelete);
        session.delete((Object)objectToDelete);
    }

    public void refresh(BasicBO objectToRefresh, String sessionName) throws Exception {
        Session session = this.sessions.get(sessionName);
        session.refresh((Object)objectToRefresh);
    }

    public BasicBO get(Object id, String strClassHandle, String sessionName) throws Exception {
        Session session = this.sessions.get(sessionName);
        BasicBO instance = (BasicBO)session.get(strClassHandle, (Serializable)id);
        session.refresh((Object)instance);
        return instance;
    }

    public List getAll(String strClassHandle, String sessionName) {
        Session session = this.sessions.get(sessionName);
        String queryString = "from " + strClassHandle;
        Query queryObject = session.createQuery(queryString);
        return queryObject.list();
    }

    public long getSequence(String sequenceName, String sessionName) throws Exception {
        String strQuery = "SELECT " + sequenceName + " .NextVal FROM Dual";
        SQLQuery queryObject = this.sessions.get(sessionName).createSQLQuery(strQuery);
        BigDecimal bigDecimal = (BigDecimal)queryObject.uniqueResult();
        return bigDecimal.longValue();
    }

    public HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    public HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }
}

