/*
 * Decompiled with CFR 0.152.
 */
package vasp.messagelogger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import transport.message.Message;
import utils.Config;
import vasp.messagelogger.RetryHandle;
import vasp.messagelogger.ServiceLog;
import vasp.utils.VaspUtils;

public class FileServiceLog
implements ServiceLog {
    protected FileWriter writer;
    protected Logger logger;
    protected String name;
    protected Object lock;
    protected SimpleDateFormat format;
    protected int date;
    protected String curPath;
    protected static final Hashtable<String, FileServiceLog> modules = new Hashtable();

    protected FileServiceLog(String name) {
        this.name = name;
        this.logger = Logger.getLogger(FileServiceLog.class);
        this.lock = new Object();
        this.format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        this.date = Calendar.getInstance().get(5);
        this.instance();
    }

    public static FileServiceLog getFileServiceLog(String name) {
        if (name == null) {
            return null;
        }
        if (modules.containsKey(name)) {
            return modules.get(name);
        }
        FileServiceLog module = new FileServiceLog(name);
        modules.put(name, module);
        return module;
    }

    public static void destroyAll() {
        Iterator<String> i = modules.keySet().iterator();
        while (i.hasNext()) {
            FileServiceLog flog = modules.get(i.next());
            flog.destroy();
        }
    }

    @Override
    public void reload() {
        this.logger.info((Object)"reload file service logger");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Message message) {
        Object object = this.lock;
        synchronized (object) {
            try {
                int curDate = Calendar.getInstance().get(5);
                if (curDate != this.date) {
                    this.date = curDate;
                    try {
                        this.logger.info((Object)("close out of date log file:" + this.curPath));
                        this.writer.close();
                    }
                    catch (IOException e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    this.instance();
                }
                this.writer.write(this.format.format(new Date()) + "\t" + message.debugString());
                this.writer.write("\r\n");
            }
            catch (IOException ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void instance() {
        try {
            String dir = Config.getLogDir() + File.separator + this.name;
            File f = new File(dir);
            if (!f.exists() && !f.mkdirs()) {
                this.logger.error((Object)"fail to close directory");
                return;
            }
            this.curPath = dir + File.separator + this.name + "." + VaspUtils.getFullDate();
            this.logger.info((Object)("create new file service log :" + this.curPath));
            this.writer = new FileWriter(this.curPath, true);
        }
        catch (IOException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer == null) {
                this.logger.warn((Object)"close null file service log");
                return;
            }
            this.logger.info((Object)("close file service log:" + this.curPath));
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void setRetryHandle(RetryHandle handle) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxSessionId() {
        return 0;
    }
}

