/*
 * Decompiled with CFR 0.152.
 */
package transport.soap;

import com.sun.net.httpserver.HttpExchange;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.xml.soap.SOAPException;
import net.homeip.donaldm.httpdbase4j.CloneableHeaders;
import net.homeip.donaldm.httpdbase4j.HttpResponse;
import net.homeip.donaldm.httpdbase4j.Postable;
import net.homeip.donaldm.httpdbase4j.Request;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;
import utils.AgentMX;
import utils.Queue;
import vasp.Authenticator;

public abstract class WsHandler
extends AgentMX
implements Postable {
    protected Authenticator authen;
    protected String name;
    protected Logger logger;
    protected Queue queue;

    public WsHandler(String name) {
        this.name = name;
        this.logger = Logger.getLogger((String)name);
    }

    public void setReceiverQueue(Queue queue) {
        this.queue = queue;
    }

    public Object onHandlePost(long id, HttpExchange ex, Request request, HttpResponse response, File dir, Object ... extraParameters) {
        String soapAction = ex.getRequestHeaders().getFirst("Soapaction");
        CloneableHeaders postParameters = request.getPOSTParameters();
        StringBuffer content = new StringBuffer();
        for (String key : postParameters.keySet()) {
            content.append(key);
            content.append("=\"");
            content.append(postParameters.getFirst(key));
        }
        this.logger.debug((Object)("receiver action:" + soapAction));
        this.logger.debug((Object)content);
        try {
            Iterator i;
            Message message = new Message((Object)content.toString());
            SOAPEnvelope envelope = message.getSOAPEnvelope();
            SOAPHeader soapHeader = (SOAPHeader)envelope.getHeader();
            SOAPHeaderElement soapHdEle = (SOAPHeaderElement)soapHeader.getFirstChild();
            String username = null;
            String password = null;
            if (soapHdEle != null) {
                i = soapHdEle.getChildElements();
                while (i != null && i.hasNext()) {
                    MessageElement element = (MessageElement)i.next();
                    String ename = element.getName();
                    String evalue = element.getValue();
                    if ("Username".equals(ename)) {
                        username = evalue;
                    }
                    if (!"Password".equals(ename)) continue;
                    password = evalue;
                }
            }
            if (this.authen != null && !this.authen.authen(username, password, "soap")) {
                this.logger.info((Object)("can't authen web service uri =" + request.getPath() + " with user=" + username + ", pass=" + password));
                response.setMimeType("text/plain");
                response.setBody("username or password is invalid");
                return response;
            }
            SOAPBody body = (SOAPBody)envelope.getBody();
            SOAPBodyElement soapMsg = (SOAPBodyElement)body.getFirstChild();
            String soapMethod = soapMsg.getName();
            Properties params = new Properties();
            i = soapMsg.getChildElements();
            while (i.hasNext()) {
                MessageElement element = (MessageElement)i.next();
                String ename = element.getName().toLowerCase(Locale.getDefault());
                String evalue = element.getValue();
                params.put(ename, evalue);
            }
            this.logger.debug((Object)("handle: " + soapMethod + "    param: " + params.toString()));
            params.put("remote-address", ex.getRemoteAddress().getAddress().getHostAddress());
            this.handle(soapMethod, params, response);
        }
        catch (AxisFault e) {
            this.logger.error((Object)("receiver soap message error:" + e.getMessage()));
            this.logger.error((Object)("error content:" + content));
            response.setMimeType("text/html");
            response.setBody("Intenal Server Error");
        }
        catch (SOAPException e) {
            this.logger.error((Object)("receiver soap message error:" + e.getMessage()));
            this.logger.error((Object)("error content:" + content));
            response.setMimeType("text/html");
            response.setBody("Intenal Server Error");
        }
        catch (Throwable t) {
            this.logger.error((Object)("receiver soap message error:" + t.getMessage()));
            this.logger.error((Object)("error content:" + content));
            response.setMimeType("text/html");
            response.setBody("Intenal Server Error");
        }
        return response;
    }

    public void destroy() {
    }

    public void setAuthen(Authenticator authen) {
        this.authen = authen;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected abstract void handle(String var1, Properties var2, HttpResponse var3);
}

