/*
 * Decompiled with CFR 0.152.
 */
package smi;

import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import net.wimpi.telnetd.net.Connection;
import net.wimpi.telnetd.net.ConnectionData;
import net.wimpi.telnetd.net.ConnectionEvent;
import net.wimpi.telnetd.net.ConnectionListener;
import net.wimpi.telnetd.shell.Shell;
import org.apache.log4j.Logger;
import smi.ShellIo;
import vasp.Authenticator;
import vasp.CommandRequest;
import vasp.CommandResponse;
import vasp.Commandable;

public final class SmiShell
implements Shell {
    private static Logger trace = Logger.getLogger(SmiShell.class);
    private static final byte[] deleteChar = new byte[]{27, 91, 49, 80};
    private static final byte[] insertChar = new byte[]{27, 91, 49, 64};
    private Connection connection = null;
    private ShellIo shellIo = null;
    private static Commandable cmdexe;
    private static int shellId;
    private boolean registed;
    private static Authenticator authen;
    final List lines = new ArrayList();
    private String username;
    int waitRead = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Connection con) {
        this.connection = con;
        this.shellIo = new ShellIo(this.connection);
        this.connection.addConnectionListener((ConnectionListener)this);
        try {
            this.shellIo.eraseScreen();
            this.shellIo.homeCursor();
            this.shellIo.setBold(true);
            this.shellIo.setForegroundColor(31);
            this.shellIo.write("Smsgate Manager Interface\r\nVersion 1.0 \r\n\r\n");
            this.shellIo.setForegroundColor(32);
            ConnectionData cd = this.connection.getConnectionData();
            String connected = "Welcome " + cd.getHostName() + " [" + cd.getHostAddress() + ":" + cd.getPort() + "]";
            trace.info((Object)connected);
            this.waitRead = 1;
            this.shellIo.write(connected + "\r\n\r\n");
            this.shellIo.setBold(false);
            this.shellIo.write("smsws>Username:");
            this.shellIo.resetAttributes();
            this.shellIo.flush();
            this.listenCmd();
        }
        catch (IOException e) {
            trace.fatal((Object)e, (Throwable)e);
        }
        catch (Error e) {
            trace.fatal((Object)e, (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            trace.fatal((Object)e, e);
        }
    }

    public void listenCmd() {
        try {
            int lineNumber = -1;
            StringBuffer inputBuffer = new StringBuffer();
            int cursor = 0;
            boolean listening = true;
            block12: do {
                int c = this.shellIo.read();
                if (trace.isDebugEnabled()) {
                    trace.debug((Object)("STDIN> " + c + " " + (char)c));
                }
                switch (c) {
                    case 1302: {
                        trace.debug((Object)"STDIN> DELETE");
                        if (cursor >= inputBuffer.length()) continue block12;
                        inputBuffer.deleteCharAt(cursor);
                        this.shellIo.write(deleteChar);
                        break;
                    }
                    case 1303: {
                        trace.debug((Object)"STDIN> BACKSPACE");
                        if (cursor <= 0) continue block12;
                        inputBuffer.deleteCharAt(cursor - 1);
                        --cursor;
                        this.shellIo.write('\b');
                        this.shellIo.write(deleteChar);
                        break;
                    }
                    case 1004: {
                        trace.debug((Object)"STDIN> LEFT");
                        if (cursor <= 0) continue block12;
                        --cursor;
                        this.shellIo.write('\b');
                        break;
                    }
                    case 1003: {
                        trace.debug((Object)"STDIN> RIGHT");
                        if (cursor >= inputBuffer.length()) continue block12;
                        this.shellIo.moveRight(1);
                        ++cursor;
                        break;
                    }
                    case 1001: {
                        trace.debug((Object)"STDIN> UP");
                        if (this.lines.size() <= 0 || lineNumber < 0) continue block12;
                        if (inputBuffer.length() > cursor) {
                            this.shellIo.write(SmiShell.deleteChars(inputBuffer.length() - cursor));
                        }
                        for (int i = 0; i < cursor; ++i) {
                            this.shellIo.write('\b');
                            this.shellIo.write(deleteChar);
                        }
                        String line = (String)this.lines.get(lineNumber);
                        if (lineNumber > 0) {
                            --lineNumber;
                        }
                        this.shellIo.write(line);
                        inputBuffer.setLength(0);
                        inputBuffer.append(line);
                        cursor = line.length();
                        break;
                    }
                    case 1002: {
                        trace.debug((Object)"STDIN> DOWN");
                        if (lineNumber < 0 || lineNumber >= this.lines.size()) continue block12;
                        if (inputBuffer.length() > cursor) {
                            this.shellIo.write(SmiShell.deleteChars(inputBuffer.length() - cursor));
                        }
                        for (int i = 0; i < cursor; ++i) {
                            this.shellIo.write('\b');
                            this.shellIo.write(deleteChar);
                        }
                        String line = (String)this.lines.get(lineNumber);
                        if (lineNumber + 1 < this.lines.size()) {
                            ++lineNumber;
                        }
                        this.shellIo.write(line);
                        inputBuffer.setLength(0);
                        inputBuffer.append(line);
                        cursor = line.length();
                        break;
                    }
                    case 10: {
                        String str;
                        trace.debug((Object)"STDIN> ENTER");
                        this.shellIo.write("\r\n");
                        cursor = 0;
                        this.lines.add(inputBuffer.toString());
                        lineNumber = this.lines.size() - 1;
                        inputBuffer.setLength(0);
                        if (this.lines.size() <= 0 || this.exe(str = (String)this.lines.get(this.lines.size() - 1)) != 0) continue block12;
                        listening = false;
                        this.shellIo.write("bye");
                        break;
                    }
                    default: {
                        if (c < 256) {
                            trace.debug((Object)"STDIN> no special char");
                            this.shellIo.write(insertChar);
                            if (this.waitRead == 2) {
                                this.shellIo.write("*");
                            } else {
                                this.shellIo.write((char)c);
                            }
                            inputBuffer.insert(cursor, (char)c);
                            ++cursor;
                            break;
                        }
                        trace.debug((Object)"STDIN> unknown char");
                    }
                }
            } while (this.connection.isActive() && listening);
        }
        catch (SocketException e) {
            trace.warn((Object)("connection closed:" + e));
        }
        catch (IOException e) {
            trace.warn((Object)e, (Throwable)e);
        }
    }

    public void connectionTimedOut(ConnectionEvent ce) {
        try {
            this.shellIo.setBold(true);
            this.shellIo.setForegroundColor(31);
            this.shellIo.write("\r\n");
            this.shellIo.write("CONNECTION TIMEDOUT");
            this.shellIo.write("\r\n");
            this.shellIo.write("Bye bye");
            this.shellIo.write("\r\n");
            this.shellIo.flush();
        }
        catch (IOException e) {
            trace.fatal((Object)e, (Throwable)e);
        }
        this.connection.close();
    }

    public void connectionIdle(ConnectionEvent ce) {
        try {
            this.shellIo.write("\r\n");
            this.shellIo.write("CONNECTION IDLE (ignored)");
            this.shellIo.write("\r\n");
            this.shellIo.flush();
        }
        catch (IOException e) {
            trace.fatal((Object)e, (Throwable)e);
        }
    }

    public void connectionLogoutRequest(ConnectionEvent ce) {
        try {
            this.shellIo.setBold(false);
            this.shellIo.setForegroundColor(32);
            this.shellIo.write("\r\n");
            this.shellIo.write("CONNECTION LOGOUTREQUEST");
            this.shellIo.write("\r\n");
            this.shellIo.write("Bye bye");
            this.shellIo.write("\r\n");
            this.shellIo.flush();
        }
        catch (IOException e) {
            trace.fatal((Object)e, (Throwable)e);
        }
        this.connection.close();
    }

    public void connectionSentBreak(ConnectionEvent ce) {
        try {
            this.shellIo.write("\r\n");
            this.shellIo.write("CONNECTION BREAK (ignored)");
            this.shellIo.write("\r\n");
            this.shellIo.flush();
        }
        catch (IOException e) {
            trace.fatal((Object)e, (Throwable)e);
        }
    }

    public static Shell createShell() {
        if (++shellId == Integer.MAX_VALUE) {
            shellId = 0;
        }
        return new SmiShell();
    }

    private static final byte[] deleteChars(int number) {
        StringBuffer result = new StringBuffer();
        result.append('\u001b');
        result.append('[');
        result.append(number);
        result.append('P');
        return result.toString().getBytes();
    }

    public boolean isRegisted() {
        return this.registed;
    }

    public void setRegisted(boolean registed) {
        this.registed = registed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int exe(String cmd) {
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                if (!"quit".equals(cmd) && !"bye".equals(cmd) && !"exit".equals(cmd)) break block18;
                                int n = 0;
                                return n;
                            }
                            if (!"login".equals(cmd)) break block19;
                            this.shellIo.write("smsws>Username:");
                            this.waitRead = 1;
                            int n = 1;
                            return n;
                        }
                        if (!"logout".equals(cmd) || !this.isRegisted()) break block20;
                        this.setRegisted(false);
                        this.shellIo.write(this.username + " loggedout\r\n");
                        this.shellIo.write("smsws>");
                        this.waitRead = 0;
                        int n = 1;
                        return n;
                    }
                    if (this.waitRead != 1) break block21;
                    this.waitRead = 2;
                    this.shellIo.write("smsws>Password:");
                    int n = 1;
                    return n;
                }
                if (this.waitRead != 2) break block22;
                this.waitRead = 0;
                if (this.lines.size() <= 1) break block22;
                this.username = (String)this.lines.get(this.lines.size() - 2);
                String password = (String)this.lines.get(this.lines.size() - 1);
                if (authen.authen(this.username, password, "smi")) {
                    this.setRegisted(true);
                    this.shellIo.write(this.username + " logged in\r\n");
                } else {
                    this.setRegisted(false);
                    this.shellIo.write("username or password is invalid\r\n");
                }
                this.shellIo.write("smsws>");
                int n = 1;
                return n;
            }
            if (this.isRegisted() || this.waitRead != 0) break block23;
            this.shellIo.write("Permittion deny\r\n");
            this.shellIo.write("smsws>");
            int password = 1;
            return password;
        }
        try {
            if (cmd.startsWith("restart") || cmd.startsWith("reload") || cmd.startsWith("show") || cmd.startsWith("?") || cmd.startsWith("help") || cmd.startsWith("clear")) {
                if (cmdexe != null) {
                    String sshellId = "shell_" + shellId;
                    CommandRequest cmdRequest = new CommandRequest(sshellId, cmd);
                    CommandResponse cmdResponse = cmdexe.exec(cmdRequest);
                    if (cmdResponse == null) {
                        this.shellIo.write("execute command error");
                    } else {
                        this.shellIo.write(cmdResponse.getDescription());
                    }
                    this.shellIo.write("\r\n");
                    this.shellIo.write("smsws>");
                } else {
                    this.shellIo.write("smsws can't execute command\r\n");
                    this.shellIo.write("smsws>");
                }
            } else {
                this.shellIo.write("invalid command\r\n");
                this.shellIo.write("smsws>");
            }
            int sshellId = 1;
            return sshellId;
        }
        catch (IOException ex) {
            trace.error((Object)ex.getMessage(), (Throwable)ex);
            int n = 0;
            return n;
        }
    }

    public static void setCmdexe(Commandable cmdexe) {
        SmiShell.cmdexe = cmdexe;
    }

    public static void setAuthen(Authenticator authen) {
        SmiShell.authen = authen;
    }
}

