/*
 * Decompiled with CFR 0.152.
 */
package event;

import event.EventInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import org.apache.log4j.Logger;
import transport.message.Message;
import transport.message.NotifyMessage;
import transport.message.SmsData;
import utils.Config;
import utils.LoadableAgentMX;
import utils.Queue;
import vasp.utils.ConfigParser;
import vasp.utils.VaspUtils;

public class SmsWarning
extends LoadableAgentMX
implements EventInterface {
    public static final String SMSWARN = "SmsWarning";
    protected String sender;
    protected String[] receiver;
    protected String[] module;
    int startTime;
    int endTime;
    Queue gateQueue;
    Logger logger = Logger.getLogger((String)"SmsWarning");
    private static int max_sms_rate = 100;

    public static String getCurrentEnvironmentNetworkIp() {
        return System.getProperty("com.viettel.mmserver.agent.ip");
    }

    public static int getMaxSmsRate() {
        return max_sms_rate;
    }

    public SmsWarning() {
        this.reload();
        try {
            this.registerAgent("smsws.gateway:type=Events,name=SmsWarning");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    @Override
    public void onEvent(Message message) {
        if (!(message instanceof NotifyMessage)) {
            return;
        }
        int hour = Calendar.getInstance().get(11);
        if (hour < this.startTime || hour > this.endTime) {
            return;
        }
        NotifyMessage notify = (NotifyMessage)message;
        if (notify.isIgnore()) {
            return;
        }
        boolean ignore = true;
        if (this.module != null) {
            for (String mdl : this.module) {
                if (!mdl.equalsIgnoreCase(notify.getModule())) continue;
                ignore = false;
                break;
            }
        }
        if (!ignore) {
            InetAddress addr = null;
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            String host = "";
            if (addr != null) {
                host = "[SMSGW:" + SmsWarning.getCurrentEnvironmentNetworkIp() + "]";
            }
            String warning = host + " " + notify.getName() + " " + notify.getState();
            SmsData smsdata = new SmsData(this.sender, this.receiver, warning);
            this.gateQueue.enqueue((Object)smsdata);
        }
    }

    @Override
    public void setQueue(Queue queue) {
        this.gateQueue = queue;
    }

    @Override
    public void reload() {
        try {
            String configFile = Config.getConfigDir() + File.separator + "sms-warning.conf";
            this.logger.info((Object)("load config file from : " + configFile));
            WarningConfigParser parser = new WarningConfigParser(SMSWARN);
            parser.parser(configFile);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        this.receiver = null;
        try {
            this.unregisterAgent("smsws.gateway:type=Events,name=SmsWarning");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceNotFoundException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    @Override
    public String getInfor() {
        StringBuffer buff = new StringBuffer("Sms Warning");
        buff.append("\r\nSender = " + this.sender);
        buff.append("\r\nReceiver = " + VaspUtils.add(this.receiver));
        buff.append("\r\nModule = " + VaspUtils.add(this.module));
        buff.append("\r\nMax_Hour = " + this.endTime);
        buff.append("\r\nMin_Hour = " + this.startTime);
        buff.append("\r\nMax_Speed = " + max_sms_rate);
        return buff.toString();
    }

    @Override
    public String getName() {
        return SMSWARN;
    }

    class WarningConfigParser
    extends ConfigParser {
        public WarningConfigParser(String name) {
            super(name);
        }

        @Override
        protected void onValue(String name, String value) {
            super.onValue(name, value);
            if ("sender".equals(name)) {
                SmsWarning.this.sender = value;
            } else if ("min_hour".equals(name)) {
                SmsWarning.this.startTime = VaspUtils.getInt(value, 8);
            } else if ("max_hour".equals(name)) {
                SmsWarning.this.endTime = VaspUtils.getInt(value, 8);
            } else if ("max_speed".equals(name)) {
                max_sms_rate = VaspUtils.getInt(value, 100);
            }
        }

        @Override
        protected void onValue(String name, String[] value) {
            super.onValue(name, value);
            if ("receiver".equals(name)) {
                SmsWarning.this.receiver = value;
            } else if ("module".equals(name)) {
                SmsWarning.this.module = value;
            }
        }
    }
}

