/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetUtil {
    public static Set<Long> fromArray(long[] array) {
        if (array == null || array.length == 0) {
            return new HashSet<Long>();
        }
        HashSet<Long> set = new HashSet<Long>(array.length);
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public static Set fromArray(Object[] array) {
        if (array == null || array.length == 0) {
            return new HashSet();
        }
        HashSet<Object> set = new HashSet<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public static Set fromCollection(Collection c) {
        if (c != null && c instanceof Set) {
            return (Set)c;
        }
        if (c == null || c.size() == 0) {
            return new HashSet();
        }
        HashSet set = new HashSet(c.size());
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            set.add(itr.next());
        }
        return set;
    }

    public static Set fromEnumeration(Enumeration enu) {
        HashSet set = new HashSet();
        while (enu.hasMoreElements()) {
            set.add(enu.nextElement());
        }
        return set;
    }

    public static Set fromIterator(Iterator itr) {
        HashSet set = new HashSet();
        while (itr.hasNext()) {
            set.add(itr.next());
        }
        return set;
    }

    public static Set fromFile(String fileName) throws IOException {
        return SetUtil.fromFile(new File(fileName));
    }

    public static Set fromFile(File file) throws IOException {
        HashSet<String> set = new HashSet<String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String s = "";
        while ((s = br.readLine()) != null) {
            set.add(s);
        }
        br.close();
        return set;
    }

    public static Set fromList(List array) {
        if (array == null || array.size() == 0) {
            return new HashSet();
        }
        HashSet set = new HashSet(array.size());
        for (int i = 0; i < array.size(); ++i) {
            set.add(array.get(i));
        }
        return set;
    }

    public static Set fromString(String s) {
        return SetUtil.fromArray(StringUtil.split(s, "\n"));
    }
}

