/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Util;

public class LazyThreadFactory
extends DefaultThreadFactory {
    private Collection<WeakReference<Thread>> threads = new ConcurrentLinkedQueue<WeakReference<Thread>>();
    private static final StringBuilder ADDR = new StringBuilder("<ADDR>");
    private static final StringBuilder CL_NAME = new StringBuilder("<CL-NAME>");

    public LazyThreadFactory(ThreadGroup group, String baseName, boolean createDaemons) {
        super(group, baseName, createDaemons);
    }

    public LazyThreadFactory(ThreadGroup group, String baseName, boolean createDaemons, boolean use_numbering) {
        super(group, baseName, createDaemons, use_numbering);
    }

    @Override
    public Thread newThread(ThreadGroup group, Runnable r, String name) {
        String cluster_name;
        Thread retval = null;
        String addr = this.address;
        if (addr == null) {
            addr = "<ADDR>";
        }
        if ((cluster_name = this.clusterName) == null) {
            cluster_name = "<CL-NAME>";
        }
        retval = super.newThread(group, r, name, addr, cluster_name);
        this.threads.add(new WeakReference<Thread>(retval));
        return retval;
    }

    @Override
    public void setAddress(String address) {
        boolean changed = false;
        if (!Util.match(this.address, address)) {
            changed = true;
        }
        super.setAddress(address);
        if (changed) {
            this.renameThreads();
        }
    }

    @Override
    public void setClusterName(String cluster_name) {
        boolean changed = false;
        if (!Util.match(this.clusterName, cluster_name)) {
            changed = true;
        }
        super.setClusterName(cluster_name);
        if (changed) {
            this.renameThreads();
        }
    }

    protected void renameThreads() {
        Iterator<WeakReference<Thread>> it = this.threads.iterator();
        while (it.hasNext()) {
            WeakReference<Thread> ref = it.next();
            Thread thread = (Thread)ref.get();
            if (thread == null) {
                it.remove();
                continue;
            }
            String name = thread.getName();
            name = this.changeName(name);
            thread.setName(name);
        }
    }

    private String changeName(String name) {
        StringBuilder tmp;
        String retval = name;
        if (this.address != null) {
            tmp = new StringBuilder(this.address);
            retval = retval.replace(ADDR, tmp);
        }
        if (this.clusterName != null) {
            tmp = new StringBuilder(this.clusterName);
            retval = retval.replace(CL_NAME, tmp);
        }
        return retval;
    }
}

