/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.stack.Interval;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.Range;
import org.jgroups.util.Seqno;
import org.jgroups.util.SeqnoComparator;
import org.jgroups.util.SeqnoRange;
import org.jgroups.util.TimeScheduler;

public class RangeBasedRetransmitter
extends Retransmitter {
    private final Map<Seqno, Seqno> ranges = Collections.synchronizedSortedMap(new TreeMap(new SeqnoComparator()));
    private final Map<Seqno, Retransmitter.Task> tasks = new ConcurrentHashMap<Seqno, Retransmitter.Task>();
    private final AtomicLong num_missing_seqnos = new AtomicLong(0L);
    private final AtomicLong num_ranges = new AtomicLong(0L);
    private final AtomicLong num_single_msgs = new AtomicLong(0L);

    public RangeBasedRetransmitter(Address sender, Retransmitter.RetransmitCommand cmd, TimeScheduler sched) {
        super(sender, cmd, sched);
    }

    @Override
    public void add(long first_seqno, long last_seqno) {
        Seqno range;
        if (first_seqno > last_seqno) {
            long tmp = first_seqno;
            first_seqno = last_seqno;
            last_seqno = tmp;
        }
        this.num_missing_seqnos.addAndGet(last_seqno - first_seqno + 1L);
        Seqno seqno = range = first_seqno == last_seqno ? new Seqno(first_seqno) : new SeqnoRange(first_seqno, last_seqno);
        if (range instanceof SeqnoRange) {
            this.num_ranges.incrementAndGet();
        } else {
            this.num_single_msgs.incrementAndGet();
        }
        RangeTask new_task = new RangeTask(range, this.RETRANSMIT_TIMEOUTS.copy(), this.cmd, this.sender);
        Seqno old_range = this.ranges.put(range, range);
        if (old_range != null) {
            log.error("new range " + range + " overlaps with old range " + old_range);
        }
        this.tasks.put(range, new_task);
        new_task.doSchedule();
        if (log.isTraceEnabled()) {
            log.trace("added range " + this.sender + " [" + range + "]");
        }
    }

    @Override
    public int remove(long seqno) {
        int retval = 0;
        Seqno range = this.ranges.get(new Seqno(seqno, true));
        if (range == null) {
            return 0;
        }
        range.set(seqno);
        if (log.isTraceEnabled()) {
            log.trace("removed " + this.sender + " #" + seqno + " from retransmitter");
        }
        if (range.getNumberOfMissingMessages() == 0) {
            Retransmitter.Task task = this.tasks.remove(range);
            if (task != null) {
                task.cancel();
                retval = task.getNumRetransmits();
            } else {
                log.error("task for range " + range + " not found");
            }
            this.ranges.remove(range);
            if (log.isTraceEnabled()) {
                log.trace("all messages for " + this.sender + " [" + range + "] have been received; removing range");
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map<Seqno, Seqno> map = this.ranges;
        synchronized (map) {
            for (Seqno range : this.ranges.keySet()) {
                Retransmitter.Task task = this.tasks.get(range);
                if (task == null) continue;
                task.cancel();
                this.tasks.remove(range);
            }
            this.ranges.clear();
        }
        for (Retransmitter.Task task : this.tasks.values()) {
            task.cancel();
        }
        this.num_missing_seqnos.set(0L);
        this.num_ranges.set(0L);
        this.num_single_msgs.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int missing_msgs = 0;
        Map<Seqno, Seqno> map = this.ranges;
        synchronized (map) {
            for (Seqno range : this.ranges.keySet()) {
                missing_msgs += range.getNumberOfMissingMessages();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(missing_msgs).append(" messages to retransmit");
        if (missing_msgs < 50) {
            LinkedList<Range> all_missing_msgs = new LinkedList<Range>();
            for (Seqno range : this.ranges.keySet()) {
                all_missing_msgs.addAll(range.getMessagesToRetransmit());
            }
            sb.append(": ").append(all_missing_msgs);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int retval = 0;
        Map<Seqno, Seqno> map = this.ranges;
        synchronized (map) {
            for (Seqno range : this.ranges.keySet()) {
                retval += range.getNumberOfMissingMessages();
            }
        }
        return retval;
    }

    public String printStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("total seqnos=" + this.num_missing_seqnos);
        sb.append(", single seqnos=" + this.num_single_msgs);
        sb.append(", ranges=" + this.num_ranges);
        double avg_seqnos_per_range = (double)(this.num_missing_seqnos.get() - this.num_single_msgs.get()) / (double)this.num_ranges.get();
        sb.append(", seqnos / range: " + avg_seqnos_per_range);
        return sb.toString();
    }

    protected class RangeTask
    extends Retransmitter.Task {
        protected final Seqno range;

        protected RangeTask(Seqno range, Interval intervals, Retransmitter.RetransmitCommand cmd, Address msg_sender) {
            super(RangeBasedRetransmitter.this, intervals, cmd, msg_sender);
            this.range = range;
        }

        public String toString() {
            return this.range.toString();
        }

        @Override
        protected void callRetransmissionCommand() {
            Collection<Range> missing = this.range.getMessagesToRetransmit();
            if (missing.isEmpty()) {
                this.cancel();
            } else {
                for (Range range : missing) {
                    this.command.retransmit(range.low, range.high, this.msg_sender);
                }
            }
        }
    }
}

