/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.provisioning.webservice;

import com.viettel.provisioning.webservice.ActionProperty;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import utils.ConnectionException;
import utils.DataStores;

public class ProductInfoLoader {
    private HashMap<String, ActionProperty> productTables = new HashMap();
    private static ProductInfoLoader productInfoLoader1;

    public static synchronized ProductInfoLoader getInstance() throws SQLException, MalformedObjectNameException, MBeanRegistrationException, NotCompliantMBeanException, InstanceAlreadyExistsException {
        if (productInfoLoader1 == null) {
            productInfoLoader1 = new ProductInfoLoader();
        }
        return productInfoLoader1;
    }

    public synchronized ActionProperty getAction(int product, int modificationType) {
        return this.productTables.get(product + "_" + modificationType);
    }

    private ProductInfoLoader() throws SQLException {
        this.init();
    }

    public void init() throws SQLException, ConnectionException {
        this.productTables.clear();
        ResultSet rs = DataStores.doQuery((String)"select message_type, process_code, product_id, modification_type, class_name, product_service.service_id from product_service, services where product_service.service_id = services.service_id");
        while (rs.next()) {
            ActionProperty action = new ActionProperty(rs.getString("MESSAGE_TYPE"), rs.getString("PROCESS_CODE"), rs.getString("MODIFICATION_TYPE"), rs.getString("PRODUCT_ID"), rs.getString("CLASS_NAME"), rs.getString("SERVICE_ID"));
            this.productTables.put(rs.getString("PRODUCT_ID").trim() + "_" + rs.getString("MODIFICATION_TYPE").trim(), action);
        }
        rs.close();
    }

    public synchronized String infoOfProductInfo() {
        StringBuffer info = new StringBuffer();
        info.append("The product number: " + this.productTables.size() + "\n");
        info.append("Format: PRODUCT_ID_MODIFICATION_TYPE[MESSAGE_TYPE,PROCESS_CODE,PRODUCT_ID,CLASS_NAME,SERVICE_ID]\n\n");
        int count = 0;
        for (Map.Entry<String, ActionProperty> entry : this.productTables.entrySet()) {
            ActionProperty actionProperty = entry.getValue();
            info.append(++count + ". " + entry.getKey() + "[" + actionProperty.getMessageType() + ", " + actionProperty.getProcessCode() + ", " + actionProperty.getProductId() + ", " + actionProperty.getClassName() + ", " + actionProperty.getServiceId() + "]\n");
        }
        return info.toString();
    }
}

