/*
 * Decompiled with CFR 0.152.
 */
package viettel.passport.client;

import com.viettel.passport.PassportWSService;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import viettel.passport.client.AppToken;
import viettel.passport.client.ObjectToken;
import viettel.passport.client.UserToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSAValidate {
    private static ResourceBundle resourceBundler = ResourceBundle.getBundle("cas");
    private String casValidateUrl;
    private String user;
    private String password;
    private String domainCode;
    private UserToken userToken;
    private boolean successfulAuthentication;
    private static final int DEFAULT_TIME_OUT_VALUE = 5000;
    private int timeOutVal = 5000;

    public int getTimeOutVal() {
        return this.timeOutVal;
    }

    public void setTimeOutVal(int timeOutVal) {
        this.timeOutVal = timeOutVal;
    }

    public boolean isAuthenticationSuccesful() {
        return this.successfulAuthentication;
    }

    public UserToken getUserToken() {
        return this.userToken;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setCasValidateUrl(String casValidateUrl) {
        this.casValidateUrl = casValidateUrl;
    }

    public String getDomainCode() {
        return this.domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public VSAValidate() {
        this.setCasValidateUrl(resourceBundler.getString("passportServiceUrl"));
        this.setDomainCode(resourceBundler.getString("domainCode"));
    }

    public void validate() throws IOException, ParserConfigurationException {
        URL url = null;
        try {
            URL baseUrl = PassportWSService.class.getResource(".");
            url = new URL(baseUrl, this.getCasValidateUrl());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        PassportWSService pws = new PassportWSService(url, new QName("http://passport.viettel.com/", "passportWSService"));
        String entireResponse = pws.getPassportWSPort().validate(this.user, this.password, this.domainCode);
        try {
            if ("no".equalsIgnoreCase(entireResponse)) {
                this.successfulAuthentication = false;
                this.userToken = null;
                return;
            }
            this.userToken = UserToken.parseXMLResponse((String)entireResponse, (boolean)false);
            if (this.userToken != null && this.userToken.getObjectTokens() != null && this.userToken.getObjectTokens().size() > 0) {
                System.out.println("authenticate successful [username=" + this.user + "]");
                this.successfulAuthentication = true;
            } else {
                System.out.println("authenticate failure [username=" + this.user + "]");
                this.successfulAuthentication = false;
            }
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<AppToken> getAllApp() throws IOException, ParserConfigurationException {
        URL url = null;
        try {
            URL baseUrl = PassportWSService.class.getResource(".");
            url = new URL(baseUrl, this.getCasValidateUrl());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        PassportWSService pws = new PassportWSService(url, new QName("http://passport.viettel.com/", "passportWSService"));
        String entireResponse = pws.getPassportWSPort().getAllowedApp(this.user);
        return AppToken.parseApp((String)entireResponse);
    }

    public ArrayList<ObjectToken> getAllMenu() throws IOException, ParserConfigurationException, SAXException {
        Element objectEle;
        NodeList nlObjects;
        this.domainCode = this.domainCode.trim().toLowerCase();
        URL url = null;
        try {
            URL baseUrl = PassportWSService.class.getResource(".");
            url = new URL(baseUrl, this.getCasValidateUrl());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        PassportWSService pws = new PassportWSService(url, new QName("http://passport.viettel.com/", "passportWSService"));
        String entireResponse = pws.getPassportWSPort().getAppFunctions(this.domainCode);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(entireResponse)));
        ArrayList<ObjectToken> arrlObjects = new ArrayList<ObjectToken>();
        NodeList nl = doc.getElementsByTagName("ObjectAll");
        if (nl != null && nl.getLength() > 0 && (nlObjects = (objectEle = (Element)nl.item(0)).getElementsByTagName("Row")) != null && nlObjects.getLength() > 0) {
            for (int i = 0; i < nlObjects.getLength(); ++i) {
                Element el = (Element)nlObjects.item(i);
                ObjectToken mt = ObjectToken.getMenuToken((Element)el);
                arrlObjects.add(mt);
            }
        }
        return arrlObjects;
    }
}

