/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.database.config;

import com.viettel.database.BO.DateTimeRule;
import com.viettel.database.BO.LocationRule;
import com.viettel.database.BO.ModRule;
import com.viettel.database.config.BaseHibernateDAOMDB;
import com.viettel.database.config.RuleSelector;
import com.viettel.database.config.SessionFactoryElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class Config {
    private HashMap<String, String> sessions = new HashMap();
    private RuleSelector ruleSelector = new RuleSelector();

    public void loadInstance(String cfFile) throws IOException, SAXException {
        try {
            File inputFile;
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.push((Object)this);
            digester.addObjectCreate("ConfigDBC/Session-factory", SessionFactoryElement.class);
            digester.addBeanPropertySetter("ConfigDBC/Session-factory/name", "name");
            digester.addBeanPropertySetter("ConfigDBC/Session-factory/url", "url");
            digester.addSetNext("ConfigDBC/Session-factory", "addSessionFactory");
            digester.addObjectCreate("ConfigDBC/RuleSellector/Locations/location", LocationRule.class);
            digester.addBeanPropertySetter("ConfigDBC/RuleSellector/Locations/location/name", "name");
            digester.addBeanPropertySetter("ConfigDBC/RuleSellector/Locations/location/sesion-name", "session_name");
            digester.addSetNext("ConfigDBC/RuleSellector/Locations/location", "addLocationRule");
            digester.addObjectCreate("ConfigDBC/RuleSellector/Mods/Mod", ModRule.class);
            digester.addSetProperties("ConfigDBC/RuleSellector/Mods/Mod");
            digester.addBeanPropertySetter("ConfigDBC/RuleSellector/Mods/Mod/mod-value", "mod_value");
            digester.addBeanPropertySetter("ConfigDBC/RuleSellector/Mods/Mod/session-name", "session_name");
            digester.addSetNext("ConfigDBC/RuleSellector/Mods/Mod", "addModRule");
            digester.addObjectCreate("ConfigDBC/RuleSellector/Date-times/Date-time", DateTimeRule.class);
            digester.addCallMethod("ConfigDBC/RuleSellector/Date-times/Date-time/Start", "setStartDate", 0);
            digester.addCallMethod("ConfigDBC/RuleSellector/Date-times/Date-time/End", "setEndDate", 0);
            digester.addBeanPropertySetter("ConfigDBC/RuleSellector/Date-times/Date-time/session-name", "session_name");
            digester.addSetNext("ConfigDBC/RuleSellector/Date-times/Date-time", "addDateTimeRule");
            System.out.println("tuancx " + cfFile);
            String stripped = cfFile.startsWith("/") ? cfFile.substring(1) : cfFile;
            InputStream stream = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                stream = classLoader.getResourceAsStream(stripped);
                System.out.println("Load in : " + stripped);
            }
            if (stream == null) {
                stream = BaseHibernateDAOMDB.class.getResourceAsStream(cfFile);
                System.out.println("Load in : " + cfFile);
            }
            if (stream == null) {
                stream = BaseHibernateDAOMDB.class.getClassLoader().getResourceAsStream(stripped);
                System.out.println("Load in classLoader : " + stripped);
            }
            if (stream == null && (inputFile = new File(cfFile)).exists()) {
                stream = new FileInputStream(inputFile);
            }
            if (stream == null) {
                System.out.println("Khong tim thay file cau hinh");
                throw new IOException("Khong tim thay file cau hinh");
            }
            digester.parse(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void addSessionFactory(SessionFactoryElement sessionFactory) {
        this.sessions.put(sessionFactory.getName().toLowerCase(), sessionFactory.getUrl());
    }

    public void addLocationRule(LocationRule loR) {
        this.ruleSelector.addLocationRule(loR);
    }

    public void addModRule(ModRule loR) {
        this.ruleSelector.addModRule(loR);
    }

    public void addDateTimeRule(DateTimeRule loR) {
        this.ruleSelector.addDateTimeRule(loR);
    }

    public HashMap getSessions() {
        return this.sessions;
    }

    public void setSessions(HashMap sessions) {
        this.sessions = sessions;
    }

    public RuleSelector getRuleSelector() {
        return this.ruleSelector;
    }

    public static void main(String[] arg) throws IOException, SAXException {
        Config c = new Config();
        c.loadInstance("com/viettel/database/config/DBCConfig_1.xml");
        System.out.println("Tuancx " + c.sessions.size());
    }
}

