/*
 * Decompiled with CFR 0.152.
 */
package vasp.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Vector;
import utils.SystemJarLoader;
import vasp.Module;
import vasp.utils.ConfigLoader;

public class ModuleLoader
extends ConfigLoader {
    public ModuleLoader() {
        super("ModuleLoader");
    }

    public Module loadModule(String config, String mdlname) {
        this.logger.info((Object)("load " + mdlname + " module from " + config));
        try {
            String s;
            FileReader f = new FileReader(config);
            BufferedReader r = new BufferedReader(f);
            boolean isModuleConfig = false;
            String jarFile = null;
            String className = null;
            String prefix = "[" + mdlname + "]";
            while ((s = ModuleLoader.read(r)) != null) {
                if (s.startsWith("#")) continue;
                if (s.equals(prefix)) {
                    jarFile = null;
                    className = null;
                    isModuleConfig = true;
                } else if (s.startsWith("jarfile") && isModuleConfig) {
                    jarFile = ModuleLoader.getValue(s, "=");
                } else if (s.startsWith("classname") && isModuleConfig) {
                    className = ModuleLoader.getValue(s, "=");
                }
                if (!isModuleConfig || jarFile == null || className == null) continue;
                this.logger.info((Object)("load class " + className + " from " + jarFile));
                try {
                    return (Module)SystemJarLoader.loadClass((String)jarFile, (String)className);
                }
                catch (IOException ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (InstantiationException ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (PrivilegedActionException ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            r.close();
            f.close();
        }
        catch (FileNotFoundException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public <T> T[] loadConfig(String config, String mdlname, Module[] modules) {
        this.logger.info((Object)("load " + mdlname + " module from " + config));
        Vector<Module> loaded = new Vector<Module>();
        try {
            String s;
            Vector<Module> removed = new Vector<Module>();
            if (modules != null) {
                for (Module module : modules) {
                    removed.add(module);
                }
            }
            FileReader f = new FileReader(config);
            BufferedReader r = new BufferedReader(f);
            boolean isModuleConfig = false;
            String jarFile = null;
            String className = null;
            String prefix = "[" + mdlname + "]";
            while ((s = ModuleLoader.read(r)) != null) {
                if (s.startsWith("#")) continue;
                if (s.equals(prefix)) {
                    jarFile = null;
                    className = null;
                    isModuleConfig = true;
                }
                if (s.startsWith("jarfile") && isModuleConfig) {
                    jarFile = ModuleLoader.getValue(s, "=");
                } else if (s.startsWith("classname") && isModuleConfig) {
                    className = ModuleLoader.getValue(s, "=");
                }
                if (!isModuleConfig || jarFile == null || className == null || this.findModule(className, loaded) != null) continue;
                this.logger.info((Object)("load class " + className + " from " + jarFile));
                Module module = this.findModule(className, removed);
                if (module != null) {
                    module.reload();
                    loaded.add(module);
                    removed.remove(module);
                } else {
                    try {
                        module = (Module)SystemJarLoader.loadClass((String)jarFile, (String)className);
                        loaded.add(module);
                    }
                    catch (PrivilegedActionException ex) {
                        this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    catch (IOException ex) {
                        this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    catch (ClassNotFoundException ex) {
                        this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    catch (InstantiationException ex) {
                        this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    catch (IllegalAccessException ex) {
                        this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                isModuleConfig = false;
                jarFile = null;
                className = null;
            }
            r.close();
            f.close();
            for (Module destroyModule : removed) {
                destroyModule.destroy();
            }
        }
        catch (FileNotFoundException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (loaded.size() == 0) {
            return modules;
        }
        Module[] data = loaded.toArray(new Module[loaded.size()]);
        return Arrays.copyOf(data, loaded.size(), modules.getClass());
    }

    private Module findModule(String className, Vector<Module> v) {
        if (v == null) {
            return null;
        }
        for (Module module : v) {
            if (!module.getClass().getName().equals(className)) continue;
            return module;
        }
        return null;
    }
}

