/*
 * Decompiled with CFR 0.152.
 */
package vasp.utils;

import com.viettel.mmserver.base.ProcessThreadMX;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileLogger
extends ProcessThreadMX {
    private static int MAX_BUFFERED_LINE = 1024;
    private static long TIME_OUT = 60000L;
    private SimpleDateFormat fmt = new SimpleDateFormat("yyMMddHHmmssSSS'.txt'");
    private volatile long lastSave = System.currentTimeMillis();
    public String path;
    private volatile int line = 0;
    private ByteArrayOutputStream bout = null;
    private PrintWriter pout = null;

    public FileLogger() {
        super("File-logger-writer");
        this.initOutputStream();
    }

    private void initOutputStream() {
        if (this.pout != null) {
            this.pout.close();
        }
        this.bout = new ByteArrayOutputStream();
        this.pout = new PrintWriter(this.bout);
    }

    protected void process() {
        if (MAX_BUFFERED_LINE < this.line || System.currentTimeMillis() > this.lastSave + TIME_OUT) {
            this.flushToFile();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void log(String line) {
        ++this.line;
        this.pout.println(line);
        this.pout.flush();
    }

    private synchronized void flushToFile() {
        this.lastSave = System.currentTimeMillis();
        if (this.line > 0) {
            String fileName = this.fmt.format(new Date());
            try {
                FileOutputStream fout = new FileOutputStream(new File(this.path + fileName));
                fout.write(this.bout.toByteArray());
                fout.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.line = 0;
            this.initOutputStream();
        }
    }

    public void start() {
        super.start();
    }

    public void stop() {
        this.flushToFile();
        super.stop();
    }

    public static void main(String[] args) {
    }
}

