/*
 * Decompiled with CFR 0.152.
 */
package vasp.listener;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import transport.message.Request;
import transport.message.Response;
import transport.message.ServiceMessage;
import transport.tcp.message.DeliverReport;
import transport.tcp.message.SubmitResponse;
import utils.BlockQueue;
import utils.QueuingProcessThreadMX;
import vasp.MessageProcess;
import vasp.listener.AutoProcessListener;
import vasp.listener.DefaultServiceListener;
import vasp.listener.QueueableListener;
import vasp.listener.ServiceListener;
import vasp.listener.TcpServiceListener;
import vasp.utils.VaspUtils;

public class BusinessProcess
extends QueuingProcessThreadMX {
    protected MessageProcess responseProcessor;
    protected ServiceListener listener;
    protected long received;

    public BusinessProcess(String threadName, String name, ServiceListener listener, MessageProcess responseProcessor) {
        super("smsws.vasp:type=" + name + ",name=" + threadName);
        this.queue = new BlockQueue();
        this.responseProcessor = responseProcessor;
        this.listener = listener;
        if (listener instanceof DefaultServiceListener) {
            ((DefaultServiceListener)listener).setName(name);
            ((DefaultServiceListener)listener).setResponseProcess(responseProcessor);
            ((DefaultServiceListener)listener).setLogger(this.logger);
        }
        this.logger.info((Object)"class has been loaded");
        try {
            this.registerAgent("smsws.vasp:type=" + name + ",name=" + threadName);
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    public void onRequest(ServiceMessage request) {
        this.logger.debug((Object)("receive request:" + request.toString()));
        this.received = VaspUtils.increase(this.received, 1L);
        this.queue.enqueue((Object)request);
    }

    public void setListener(ServiceListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Object ob = this.queue.dequeue();
        if (this.listener instanceof AutoProcessListener) {
            ((AutoProcessListener)this.listener).process();
            return;
        }
        if (this.listener instanceof QueueableListener) {
            ((QueueableListener)this.listener).processTimeout();
        }
        if (ob instanceof Request) {
            DefaultServiceListener dflistener;
            Request request = (Request)ob;
            if (this.listener instanceof DefaultServiceListener && (dflistener = (DefaultServiceListener)this.listener).isAsyn()) {
                this.logger.debug((Object)("process asyn request:" + request.toString()));
                dflistener.serverAsyn(request);
                return;
            }
            if (this.listener != null) {
                this.logger.debug((Object)("process request:" + request.toString()));
                Response response = this.listener.server(request);
                this.responseProcessor.process(response);
            } else {
                this.logger.warn((Object)"listener is null, can't process request");
            }
        } else if (ob instanceof SubmitResponse && this.listener instanceof TcpServiceListener) {
            ((TcpServiceListener)this.listener).server((SubmitResponse)ob);
        } else if (ob instanceof DeliverReport && this.listener instanceof TcpServiceListener) {
            ((TcpServiceListener)this.listener).server((DeliverReport)ob);
        }
        if (this.queue.size() == 0) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    public String debugStatus() {
        StringBuffer buff = new StringBuffer();
        buff.append("Name:" + this.threadName);
        String className = this.listener != null ? this.listener.getClass().getName() : "null";
        buff.append("\r\nClass:" + className);
        buff.append("\r\nQueue:" + this.queueSize());
        buff.append("\r\nReceived:" + this.received);
        return buff.toString();
    }

    public void stop() {
        this.logger.info((Object)"wait for processing unprocessed message");
        this.logger.info((Object)"no more unprocessed message, going to stop process now");
        if (this.listener != null) {
            this.listener.destroy();
        }
        super.stop();
    }

    public void destroy() {
        if (this.listener != null) {
            this.listener.destroy();
        }
        super.destroy();
        try {
            this.unregisterAgent(this.logger.getName());
        }
        catch (MalformedObjectNameException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceNotFoundException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }
}

