/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp.message;

import transport.tcp.AdvanceByteBuffer;
import transport.tcp.message.AbServiceMessage;

public class DeliverReport
extends AbServiceMessage {
    private int status;

    public DeliverReport(String provider, String gateway, String messageId, String sessionId, String serviceId, String sender, String receiver, int status) {
        super(7, 113);
        this.provider = provider;
        this.gateway = gateway;
        this.messageId = messageId;
        this.sessionId = sessionId;
        this.serviceId = serviceId;
        this.sender = sender;
        this.receiver = receiver;
        this.status = status;
        this.put("Name", "DeliverReport");
        this.put("MessageId", messageId);
        this.put("SessionId", sessionId);
        this.put("ServiceId", serviceId);
        this.put("Sender", sender);
        this.put("Receiver", receiver);
        this.put("Status", status);
    }

    public DeliverReport(byte[] b) throws Exception {
        super(7, 113);
        AdvanceByteBuffer buf = new AdvanceByteBuffer(b);
        this.status = buf.popInt();
        this.receiver = buf.popCString(14);
        this.sender = buf.popCString(14);
        this.serviceId = buf.popCString(10);
        this.messageId = buf.popCString(10);
        this.gateway = buf.popCString(30);
        this.provider = buf.popCString(30);
        this.type = buf.popByte();
        this.put("Name", "DeliverReport");
        this.put("MessageId", this.messageId);
        this.put("SessionId", this.sessionId);
        this.put("ServiceId", this.serviceId);
        this.put("Sender", this.sender);
        this.put("Receiver", this.receiver);
        this.put("Status", this.status);
    }

    @Override
    public byte[] toBytes() throws Exception {
        AdvanceByteBuffer buf = new AdvanceByteBuffer();
        buf.appendByte(this.type);
        buf.appendCString(this.provider, 30);
        buf.appendCString(this.gateway, 30);
        buf.appendCString(this.messageId, 10);
        buf.appendCString(this.serviceId, 10);
        buf.appendCString(this.sender, 14);
        buf.appendCString(this.receiver, 14);
        buf.appendInt(this.status);
        return buf.array();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public String debugString() {
        return "DeliverReport " + this.sender + "->" + this.receiver + " (MessageId=" + this.messageId + ",ServiceId=" + this.serviceId + ",Status=" + this.status + ")";
    }
}

