/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;
import transport.Transport;
import transport.message.Message;
import transport.message.Request;
import transport.message.Response;
import transport.message.ServiceMessage;
import transport.tcp.StreamUtils;
import transport.tcp.TcpReceiver;
import transport.tcp.message.HeartBeat;
import transport.tcp.message.ServiceRequest;
import transport.tcp.message.TcpMessage;
import transport.tcp.message.UnBoundRequest;
import utils.BlockQueue;
import utils.ProcessThread;
import utils.Queue;
import utils.QueuingProcessorMX;
import vasp.messagelogger.ServiceLog;
import vasp.messagelogger.ServiceLogImpl;

public abstract class TcpTransport
extends QueuingProcessorMX
implements Transport {
    protected ServiceLog molog;
    protected volatile boolean connected;
    protected boolean registed;
    protected String id;
    protected String sysId;
    protected Socket socket;
    protected DataOutputStream out;
    protected DataInputStream in;
    protected TcpReceiver receiver;
    private static int MAX_HEARBEAT = 10;
    private int heartBeatCount;
    private long lastSentHeartBeatTime;
    protected volatile int numRequestMessage = 0;
    protected Object lock = new Object();
    protected int mo;
    protected int mt;
    protected Queue tx = new BlockQueue();
    protected TCPMessageSender tcpSender = new TCPMessageSender();

    public TcpTransport(String id, Socket socket) {
        this(id, null, socket);
        this.molog = ServiceLogImpl.getServiceLog().getServiceLog("MoLog");
    }

    public TcpTransport(String id, String sysId, Socket socket) {
        super(id);
        this.id = id;
        this.sysId = sysId;
        this.socket = socket;
        this.logger = Logger.getLogger(TcpTransport.class);
        this.queue = new BlockQueue();
        this.receiver = new TcpReceiver(this);
        this.receiver.setThreadName(id + "_receiver");
        this.molog = ServiceLogImpl.getServiceLog().getServiceLog("MoLog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean connected) {
        Object object = this.lock;
        synchronized (object) {
            this.connected = connected;
        }
        this.receiver.setConnected(connected);
    }

    protected void connect() {
        if (this.isConnected() || this.socket == null) {
            return;
        }
        try {
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.in == null || this.out == null) {
            return;
        }
        this.setConnected(true);
    }

    protected void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.socket = null;
        this.setConnected(false);
    }

    @Override
    public void start() {
        this.logger.info((Object)("starting " + this.getIdString() + " ..."));
        this.connect();
        this.receiver.start();
        this.tcpSender.start();
        this.logger.info((Object)(this.getIdString() + " is started"));
    }

    public boolean isStopping() {
        return this.receiver.isStopping();
    }

    @Override
    public void stop() {
        this.logger.info((Object)("stopping " + this.getIdString() + " ..."));
        this.receiver.stop();
        this.tcpSender.stop();
        this.disconnect();
        this.logger.info((Object)(this.getIdString() + " is stopped"));
    }

    @Override
    public void restart() {
        this.disconnect();
        this.connect();
    }

    @Override
    public void destroy() {
        this.receiver.destroy();
        this.tcpSender.destroy();
        this.stop();
    }

    protected abstract void onDisconnect(UnBoundRequest var1);

    protected abstract void process(TcpMessage var1);

    protected void onReceiverMessage(TcpMessage message) {
        if (message instanceof Request) {
            ++this.numRequestMessage;
        }
        if (message instanceof Request || message instanceof Response) {
            ((ServiceMessage)((Object)message)).setGateway(this.getIdString());
        } else {
            this.logger.info((Object)message.debugString());
        }
        if (message instanceof ServiceMessage && !this.isRegisted()) {
            this.logger.info((Object)message.debugString());
            this.logger.info((Object)"transport is not registed, message is dropt now");
            return;
        }
        this.process(message);
    }

    protected void checkHeartBeat() {
        if (System.currentTimeMillis() - this.lastSentHeartBeatTime > 2000L) {
            this.sendHeartBeat();
        }
    }

    protected void onReceiverHeartBeat(HeartBeat heartbeat) {
        this.heartBeatCount = 0;
    }

    @Override
    public String getIdString() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int enTx(Message msg) {
        if (msg instanceof TcpMessage) {
            this.tx.enqueue((Object)msg);
        }
        return 0;
    }

    private void sendHeartBeat() {
        ++this.heartBeatCount;
        this.lastSentHeartBeatTime = System.currentTimeMillis();
        if (this.heartBeatCount >= MAX_HEARBEAT) {
            this.logger.warn((Object)"hearbeat timeout, restart connection now");
            this.heartBeatCount = 0;
            UnBoundRequest unbound = new UnBoundRequest(this.id, this);
            this.disconnect();
            this.onDisconnect(unbound);
        } else {
            HeartBeat hbMsg = new HeartBeat();
            this.sendTcpMessage(hbMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendTcpMessage(TcpMessage message) {
        if (!this.isConnected()) {
            this.logger.warn((Object)"transport is not conneected, message couldn't not sent");
            return 1;
        }
        try {
            byte[] b = StreamUtils.createMessageStream(message);
            TcpTransport tcpTransport = this;
            synchronized (tcpTransport) {
                this.out.write(b);
                this.out.flush();
            }
            return 0;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            UnBoundRequest unbound = new UnBoundRequest(this.id, this);
            this.onDisconnect(unbound);
            return 1;
        }
    }

    @Override
    public String getSysId() {
        return this.sysId;
    }

    @Override
    public boolean isRegisted() {
        return this.registed;
    }

    @Override
    public void setSysId(String sysId) {
        this.sysId = sysId;
        this.logger = Logger.getLogger((String)sysId);
        this.logger = Logger.getLogger((String)sysId);
        this.receiver.setLogger(this.logger);
    }

    @Override
    public boolean isRequestFrom(ServiceMessage response) {
        return this.id.equals(response.getGateway());
    }

    public String getRemoteIP() {
        return this.socket.getInetAddress().getHostAddress();
    }

    class TCPMessageSender
    extends ProcessThread {
        public TCPMessageSender() {
            super("TCP-Message-Sender");
        }

        protected void process() {
            if (TcpTransport.this.tx == null) {
                return;
            }
            Object msg = TcpTransport.this.tx.dequeue();
            if (msg instanceof TcpMessage) {
                int sendstatus = TcpTransport.this.sendTcpMessage((TcpMessage)msg);
                if (msg instanceof ServiceRequest) {
                    ServiceRequest request = (ServiceRequest)msg;
                    ++TcpTransport.this.mo;
                    if (TcpTransport.this.mo == Integer.MAX_VALUE) {
                        TcpTransport.this.mo = 0;
                    }
                    int requestStatus = request.getStatus();
                    if (sendstatus == 0) {
                        int n = requestStatus = (request.getStatus() & 0x10) == 16 ? 19 : 2;
                        if (TcpTransport.this.molog != null) {
                            request.setStatus(requestStatus);
                            TcpTransport.this.molog.log(request);
                        }
                    } else {
                        if (requestStatus == 0) {
                            request.setStatus(16);
                        } else if (requestStatus == 17) {
                            request.setStatus(20);
                        } else {
                            request.setStatus(21);
                        }
                        if (TcpTransport.this.molog != null) {
                            TcpTransport.this.molog.log(request);
                        }
                    }
                }
            }
        }
    }
}

