/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp;

import java.io.IOException;
import transport.tcp.StreamUtils;
import transport.tcp.TcpTransport;
import transport.tcp.message.HeartBeat;
import transport.tcp.message.ServiceResponse;
import transport.tcp.message.TcpMessage;
import utils.ProcessThread;

public class TcpReceiver
extends ProcessThread {
    public static final int MAX_DATA = 4096;
    private TcpTransport transport;
    private byte bStart;
    private byte bEnd;
    private boolean connected;

    public TcpReceiver(TcpTransport transport) {
        super(transport.getIdString() + "_receiver");
        this.transport = transport;
        this.bStart = (byte)-3;
        this.bEnd = (byte)-1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean connected) {
        Object object = this.lock;
        synchronized (object) {
            this.connected = connected;
        }
    }

    public void process() {
        try {
            if (!this.isConnected()) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.transport.checkHeartBeat();
                return;
            }
            this.startMessage();
            int length = this.transport.in.readInt();
            if (length > 4096) {
                return;
            }
            byte[] buf = new byte[length];
            int bytes = 0;
            while (bytes < length) {
                buf[bytes++] = this.transport.in.readByte();
            }
            if (this.isEndMessage(this.bEnd)) {
                TcpMessage msg = StreamUtils.createMessage(buf);
                this.process(msg);
            }
        }
        catch (RuntimeException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transport.checkHeartBeat();
    }

    private void startMessage() throws IOException {
        byte compare = this.bStart;
        boolean startMsg = false;
        while (!startMsg) {
            byte b = this.transport.in.readByte();
            while (b != compare) {
                b = this.transport.in.readByte();
            }
            startMsg = this.isStartMessage(compare);
        }
    }

    private boolean isStartMessage(byte compare) throws IOException {
        byte b;
        int i = 1;
        while ((b = this.transport.in.readByte()) == compare && ++i < 4) {
        }
        return i == 4;
    }

    private boolean isEndMessage(byte compare) throws IOException {
        int i;
        byte b = this.transport.in.readByte();
        for (i = 1; b == compare && i < 4; ++i) {
            b = this.transport.in.readByte();
        }
        return i == 4;
    }

    protected void process(TcpMessage msg) {
        if (msg instanceof HeartBeat) {
            this.transport.onReceiverHeartBeat((HeartBeat)msg);
        } else {
            if (msg instanceof ServiceResponse) {
                ServiceResponse msgResponse = (ServiceResponse)msg;
                msgResponse.setIPSent(this.transport.getRemoteIP());
            }
            this.transport.onReceiverMessage(msg);
        }
    }
}

