/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp;

import java.io.UnsupportedEncodingException;
import transport.tcp.AdvanceByteBuffer;
import transport.tcp.message.BoundRequest;
import transport.tcp.message.BoundResponse;
import transport.tcp.message.DeliverReport;
import transport.tcp.message.HeartBeat;
import transport.tcp.message.ServiceForward;
import transport.tcp.message.ServiceRequest;
import transport.tcp.message.ServiceResponse;
import transport.tcp.message.SubmitResponse;
import transport.tcp.message.TcpMessage;

public class StreamUtils {
    public static final int startMsg = -33686019;
    public static final int endMsg = -1;
    public static final byte bStart = -3;
    public static final byte bEnd = -1;

    public static byte[] createMessageStream(TcpMessage message) throws Exception {
        AdvanceByteBuffer buf = new AdvanceByteBuffer();
        buf.appendInt(-33686019);
        buf.appendInt(message.length());
        buf.appendBytes(message.toBytes());
        buf.appendInt(-1);
        return buf.array();
    }

    public static TcpMessage createMessage(byte[] b) throws Exception {
        TcpMessage msg = null;
        byte nType = b[0];
        switch (nType) {
            case 0: {
                msg = new HeartBeat();
                break;
            }
            case 1: {
                msg = new BoundRequest(b);
                break;
            }
            case 2: {
                msg = new BoundResponse(b);
                break;
            }
            case 4: {
                msg = new ServiceRequest(b);
                break;
            }
            case 5: {
                msg = new ServiceResponse(b);
                break;
            }
            case 6: {
                msg = new ServiceForward(b);
                break;
            }
            case 8: {
                msg = new SubmitResponse(b);
                break;
            }
            case 7: {
                msg = new DeliverReport(b);
            }
        }
        return msg;
    }

    public static String getCString(byte[] data, String charset) throws UnsupportedEncodingException {
        int end = data.length;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            end = i;
            break;
        }
        int length = end;
        return new String(data, 0, length, charset).trim();
    }

    public static String getCString(byte[] data) {
        int end = data.length;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            end = i;
        }
        int length = end;
        return new String(data, 0, length).trim();
    }
}

