/*
 * Decompiled with CFR 0.152.
 */
package transport.rmi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.log4j.Logger;
import transport.message.Message;
import transport.message.Response;
import transport.rmi.RMITransport;
import utils.Protocol;
import utils.Queue;

public class RmiListener
implements RMITransport {
    private static final long serialVersionUID = 20090409080903L;
    protected Protocol protocol;
    protected Queue rx;
    protected RMITransport gateRx = this;
    protected String username;
    protected String password;
    protected transient Logger logger;

    public RmiListener(String url, String username, String password, Queue rx) {
        this.rx = rx;
        this.logger = Logger.getLogger(RmiListener.class);
        this.username = username;
        this.password = password;
        this.protocol = new Protocol(url);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.logger = Logger.getLogger(RmiListener.class);
    }

    @Override
    public void process(String user, String pass, Message message) {
        if (message instanceof Response && this.username.equals(user) && this.password.equals(pass)) {
            ((Response)message).setGateway("rmi");
            this.rx.enqueue((Object)message);
        }
    }

    public void restart() {
        try {
            String url = this.protocol.getUrl();
            this.logger.info((Object)("rebind: " + url));
            Naming.rebind(url, this.gateRx);
        }
        catch (RemoteException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        try {
            String url = this.protocol.getUrl();
            this.logger.info((Object)("unbind: " + url));
            Naming.unbind(url);
            UnicastRemoteObject.unexportObject(this.gateRx, true);
        }
        catch (RemoteException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NotBoundException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void start() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RmiListener.this.export();
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    protected void export() {
        try {
            this.logger.info((Object)"start rmi server");
            UnicastRemoteObject.exportObject(this.gateRx);
            String url = this.protocol.getUrl();
            int port = this.protocol.getPort();
            LocateRegistry.createRegistry(port);
            this.logger.info((Object)("bind: " + url));
            Naming.bind(url, this.gateRx);
            this.logger.info((Object)"start rmi complete");
            this.logger.info((Object)("rmi server listening on port:" + port));
        }
        catch (RemoteException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AlreadyBoundException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void reload(String url, String username, String password) {
        if (!(this.protocol.getUrl().equals(url) && this.username.equals(username) && this.password.equals(password))) {
            this.protocol.setUrl(url);
            this.username = username;
            this.password = password;
            this.stop();
            this.start();
        }
    }
}

