/*
 * Decompiled with CFR 0.152.
 */
package smi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.wimpi.telnetd.BootException;
import net.wimpi.telnetd.io.terminal.TerminalManager;
import net.wimpi.telnetd.net.PortListener;
import net.wimpi.telnetd.shell.ShellManager;
import net.wimpi.telnetd.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import smi.SmiShell;
import utils.Config;
import vasp.Authenticator;
import vasp.Commandable;

public class SmiImpl {
    private static Log trace = LogFactory.getLog((String)"Smi");
    private List listeners;
    private ShellManager shellManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmiImpl(Authenticator authen, Commandable exeable) {
        FileInputStream in = null;
        try {
            this.listeners = new ArrayList(5);
            Properties properties = new Properties();
            String configFile = Config.getConfigDir() + File.separator + "smi.conf";
            in = new FileInputStream(configFile);
            properties.load(in);
            this.prepareShellManager(properties);
            this.prepareTerminals(properties);
            String[] listnames = StringUtil.split((String)properties.getProperty("listeners"), (String)",");
            for (int i = 0; i < listnames.length; ++i) {
                this.prepareListener(listnames[i], properties);
            }
            SmiShell.setAuthen(authen);
            SmiShell.setCmdexe(exeable);
        }
        catch (FileNotFoundException ex) {
            trace.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            trace.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (BootException ex) {
            trace.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    trace.error((Object)("fail to close stream:" + ex));
                }
            }
        }
    }

    public void start() {
        trace.debug((Object)"start()");
        for (int i = 0; i < this.listeners.size(); ++i) {
            PortListener plis = (PortListener)this.listeners.get(i);
            plis.start();
        }
    }

    public void stop() {
        trace.debug((Object)"stop()");
        for (int i = 0; i < this.listeners.size(); ++i) {
            PortListener plis = (PortListener)this.listeners.get(i);
            plis.stop();
        }
    }

    private void prepareShellManager(Properties settings) throws BootException {
        this.shellManager = ShellManager.createShellManager((Properties)settings);
        if (this.shellManager == null) {
            trace.fatal((Object)"creation of shell manager failed");
        }
    }

    private void prepareListener(String name, Properties settings) throws BootException {
        int port = 0;
        try {
            port = Integer.parseInt(settings.getProperty(name + ".port"));
            ServerSocket socket = new ServerSocket(port);
            socket.close();
        }
        catch (NumberFormatException e) {
            trace.fatal((Object)e, (Throwable)e);
            throw new BootException("Failure while parsing port number for \"" + name + ".port\": " + e.getMessage());
        }
        catch (IOException e) {
            trace.fatal((Object)e, (Throwable)e);
            throw new BootException("Failure while starting listener for port number " + port + ": " + e.getMessage());
        }
        PortListener listener = PortListener.createPortListener((String)name, (Properties)settings);
        try {
            this.listeners.add(listener);
        }
        catch (RuntimeException e) {
            trace.fatal((Object)e, (Throwable)e);
            throw new BootException("Failure while starting PortListener thread: " + e.getMessage());
        }
    }

    private void prepareTerminals(Properties terminals) throws BootException {
        TerminalManager.createTerminalManager((Properties)terminals);
    }
}

