/*
 * Decompiled with CFR 0.152.
 */
package utils;

import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import utils.ProcessorMX;
import utils.Queue;

public abstract class QueuingProcessorMX
extends ProcessorMX {
    protected Queue queue;

    public QueuingProcessorMX(String threadName) {
        super(threadName);
    }

    public int queueSize() {
        return this.queue != null ? this.queue.size() : 0;
    }

    protected void dumpQueue(String queueName, Queue queue) {
        this.logger.info((Object)("queue size [" + queueName + "]"));
        if (queue == null) {
            this.logger.info((Object)"queue is null");
        } else if (queue.isEmpty()) {
            this.logger.info((Object)"queue is empty");
        } else {
            Object[] obs;
            for (Object ob : obs = queue.toArray()) {
                this.logger.info((Object)ob.toString());
            }
        }
    }

    public void dumpQueue() {
        this.dumpQueue(this.name, this.queue);
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("queueSize")) {
            return this.queueSize();
        }
        if (operationName.equals("dumpQueue")) {
            this.dumpQueue();
            return null;
        }
        return super.invoke(operationName, params, signature);
    }

    protected MBeanOperationInfo[] buildOperations() {
        MBeanOperationInfo[] mbInfors = super.buildOperations();
        MBeanOperationInfo[] mbNewInfors = new MBeanOperationInfo[mbInfors.length + 2];
        System.arraycopy(mbInfors, 0, mbNewInfors, 0, mbInfors.length);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        mbNewInfors[mbInfors.length] = new MBeanOperationInfo("queueSize", "the the current message in queue", params, "java.lang.Integer", 1);
        mbNewInfors[mbInfors.length + 1] = new MBeanOperationInfo("dumpQueue", "dump queue status", params, "void", 1);
        return mbNewInfors;
    }
}

