/*
 * Decompiled with CFR 0.152.
 */
package utils;

import org.apache.log4j.Logger;

public class CharacterConvert {
    private static Logger logger;
    public static char[][] signChars;

    private CharacterConvert() {
    }

    public static final String toUnSign(String orgStr) {
        if (orgStr == null || orgStr.length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < orgStr.length(); ++i) {
            char c = CharacterConvert.toUnsign(orgStr.charAt(i));
            buf.append(c);
        }
        return buf.toString();
    }

    public static final String toSmsText(String orgStr) {
        if (orgStr == null || orgStr.length() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int max = (orgStr = orgStr.trim()).length() > 300 ? 300 : orgStr.length();
        for (int i = 0; i < max; ++i) {
            char c = CharacterConvert.toUnsign(orgStr.charAt(i));
            if (!CharacterConvert.isSmsChar(c) && c != ' ') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static final boolean isSmsChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static final char toUnsign(char c) {
        char[][] arr$ = signChars;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char[] signChar;
            for (char aSignChar : signChar = arr$[i$]) {
                if (aSignChar != c) continue;
                return signChar[0];
            }
        }
        return c;
    }

    public static final String n2aEncode(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] buf = str.toCharArray();
        int len = buf.length;
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (buf[i] > '\u007f') {
                out.append('\\');
                out.append('u');
                String hex = Integer.toHexString(buf[i]);
                int length = 4 - hex.length();
                for (int j = 0; j < length; ++j) {
                    out.append('0');
                }
                out.append(hex);
                continue;
            }
            out.append(buf[i]);
        }
        return out.toString();
    }

    public static final String n2aDecode(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] buf = str.toCharArray();
        int len = buf.length;
        int index = 0;
        StringBuffer out = new StringBuffer();
        while (index < len) {
            if (index < len - 6 && buf[index] == '\\' && buf[index + 1] == 'u') {
                String s = new String(buf, index + 2, 4);
                try {
                    char c = (char)Integer.parseInt(s, 16);
                    out.append(c);
                    index += 6;
                }
                catch (NumberFormatException e) {
                    if (logger != null) {
                        logger.warn((Object)(e.getMessage() + "->partern:" + s));
                    }
                    out.append(buf[index]);
                    out.append(buf[index + 1]);
                    index += 2;
                }
                continue;
            }
            out.append(buf[index]);
            ++index;
        }
        return out.toString();
    }

    public static void setLogger(Logger logger) {
        CharacterConvert.logger = logger;
    }

    static {
        signChars = new char[][]{{'a', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u0103', '\u1ea1', '\u1ea3', '\u1ea5', '\u1ea7', '\u1ea9', '\u1eab', '\u1ead', '\u1eaf', '\u1eb1', '\u1eb3', '\u1eb5', '\u1eb7'}, {'A', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u0102', '\u1ea0', '\u1ea2', '\u1ea4', '\u1ea6', '\u1ea8', '\u1eaa', '\u1eac', '\u1eae', '\u1eb0', '\u1eb2', '\u1eb4', '\u1eb6'}, {'o', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u01a1', '\u1ecd', '\u1ecf', '\u1ed1', '\u1ed3', '\u1ed5', '\u1ed7', '\u1ed9', '\u1edd', '\u1edb', '\u1edf', '\u1ee1', '\u1ee3'}, {'O', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u01a0', '\u1ecc', '\u1ece', '\u1ed0', '\u1ed2', '\u1ed4', '\u1ed6', '\u1ed8', '\u1eda', '\u1edc', '\u1ede', '\u1ee0', '\u1ee2'}, {'e', '?', '\u00e8', '\u00e9', '\u00ea', '\u1eb9', '\u1ebb', '\u1ebd', '\u1ebf', '\u1ec1', '\u1ec3', '\u1ec5', '\u1ec7'}, {'E', '\u00c8', '\u00c9', '\u00ca', '\u1eb8', '\u1eba', '\u1ebc', '\u1ebe', '\u1ec0', '\u1ec2', '\u1ec4', '\u1ec6'}, {'u', '\u00f9', '\u00fa', '\u0169', '\u01b0', '\u1ee5', '\u1ee7', '\u1ee9', '\u1eeb', '\u1eed', '\u1eef', '\u1ef1'}, {'U', '\u00d9', '\u00da', '\u0168', '\u01af', '\u1ee4', '\u1ee6', '\u1ee8', '\u1eea', '\u1eec', '\u1eee', '\u1ef0'}, {'i', '\u00ec', '\u00ed', '\u0129', '\u1ec9', '\u1ecb'}, {'I', '\u00cc', '\u00cd', '\u012a', '\u1ec8', '\u1eca'}, {'y', '\u00fd', '\u1ef3', '\u1ef5', '\u1ef7', '\u1ef9'}, {'Y', '\u00fc', '\u1ef2', '\u1ef4', '\u1ef6', '\u1ef8'}, {'d', '\u0111'}, {'D', '\u0110'}};
    }
}

