/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public abstract class AgentMX
implements DynamicMBean {
    protected String dClassName = this.getClass().getName();
    protected String dDescription;
    protected MBeanAttributeInfo[] dAttributes;
    protected MBeanConstructorInfo[] dConstructors;
    protected MBeanOperationInfo[] dOperations;
    protected MBeanNotificationInfo[] dNotifications;
    protected MBeanInfo dMBeanInfo;

    public abstract String getInfor();

    public AgentMX() {
        this.buildDynamicMBeanInfo();
    }

    protected void registerAgent(String objName) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName mbeanName;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (!mbs.isRegistered(mbeanName = new ObjectName(objName))) {
            mbs.registerMBean(this, mbeanName);
        }
    }

    protected void unregisterAgent(String objName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName mbeanName;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbs.isRegistered(mbeanName = new ObjectName(objName))) {
            mbs.unregisterMBean(mbeanName);
        }
    }

    public Object getAttribute(String attribute_name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        throw new AttributeNotFoundException("Cannot find " + attribute_name + " attribute in " + this.dClassName);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String name = attribute.getName();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        throw new AttributeNotFoundException("Attribute " + name + " not found in " + this.getClass().getName());
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (MBeanException e) {
                e.printStackTrace();
                continue;
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes cannot be null"), "Cannot invoke a setter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        for (Attribute attr : attributes) {
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
            catch (InvalidAttributeValueException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("getInfor")) {
            return this.getInfor();
        }
        throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.dClassName);
    }

    public MBeanInfo getMBeanInfo() {
        return this.dMBeanInfo;
    }

    protected MBeanAttributeInfo[] buildAttributes() {
        return new MBeanAttributeInfo[0];
    }

    protected MBeanOperationInfo[] buildOperations() {
        ArrayList<MBeanOperationInfo> v = new ArrayList<MBeanOperationInfo>();
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        v.add(new MBeanOperationInfo("getInfor", "get agent description", params, "java.lang.String", 1));
        return v.toArray(new MBeanOperationInfo[v.size()]);
    }

    protected MBeanConstructorInfo[] buildConstructors() {
        ArrayList<MBeanConstructorInfo> v = new ArrayList<MBeanConstructorInfo>();
        Constructor<?>[] constructors = this.getClass().getConstructors();
        if (constructors != null && constructors.length > 0) {
            v.add(new MBeanConstructorInfo("Constructs a service object", constructors[0]));
            return v.toArray(new MBeanConstructorInfo[v.size()]);
        }
        return new MBeanConstructorInfo[0];
    }

    protected MBeanNotificationInfo[] buildNotifications() {
        return new MBeanNotificationInfo[0];
    }

    protected void buildDynamicMBeanInfo() {
        this.dDescription = "The process which run in a separator thread";
        this.dAttributes = this.buildAttributes();
        this.dConstructors = this.buildConstructors();
        this.dOperations = this.buildOperations();
        this.dNotifications = this.buildNotifications();
        this.dMBeanInfo = new MBeanInfo(this.dClassName, this.dDescription, this.dAttributes, this.dConstructors, this.dOperations, this.dNotifications);
    }
}

