/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.toolkit;

import java.io.IOException;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.toolkit.BufferOverflowException;
import net.wimpi.telnetd.io.toolkit.CharBuffer;

class Editline {
    private Buffer m_Buffer;
    private BasicTerminalIO m_IO;
    private int m_Cursor = 0;
    private boolean m_InsertMode = true;
    private int m_LastSize = 0;
    private boolean m_HardWrapped = false;
    private char m_LastRead;
    private int m_LastCursPos = 0;

    public Editline(BasicTerminalIO io) {
        this.m_IO = io;
        this.m_Buffer = new Buffer(this.m_IO.getColumns() - 1);
        this.m_Cursor = 0;
        this.m_InsertMode = true;
    }

    public int size() {
        return this.m_Buffer.size();
    }

    public String getValue() {
        return this.m_Buffer.toString();
    }

    public void setValue(String str) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.clear();
        this.m_Cursor = 0;
        this.m_IO.moveLeft(this.m_LastSize);
        this.m_IO.eraseToEndOfLine();
        this.append(str);
    }

    public void clear() throws IOException {
        this.storeSize();
        this.m_Buffer.clear();
        this.m_Cursor = 0;
        this.draw();
    }

    public String getSoftwrap() throws IndexOutOfBoundsException, IOException {
        String content = this.m_Buffer.toString();
        int idx = content.lastIndexOf(" ");
        if (idx == -1) {
            content = "";
        } else {
            content = content.substring(idx + 1, content.length());
            this.m_Cursor = this.size();
            this.m_Cursor -= content.length();
            for (int i = 0; i < content.length(); ++i) {
                this.m_Buffer.removeCharAt(this.m_Cursor);
            }
            this.m_IO.moveLeft(content.length());
            this.m_IO.eraseToEndOfLine();
        }
        return content + this.getLastRead();
    }

    public String getHardwrap() throws IndexOutOfBoundsException, IOException {
        String content = this.m_Buffer.toString();
        content = content.substring(this.m_Cursor, content.length());
        int lastsize = this.m_Buffer.size();
        for (int i = this.m_Cursor; i < lastsize; ++i) {
            this.m_Buffer.removeCharAt(this.m_Cursor);
        }
        this.m_IO.eraseToEndOfLine();
        return content;
    }

    private void setCharAt(int pos, char ch) throws IndexOutOfBoundsException, IOException {
        this.m_Buffer.setCharAt(pos, ch);
        this.draw();
    }

    private void insertCharAt(int pos, char ch) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(1);
        this.m_Buffer.insertCharAt(pos, ch);
        if (this.m_Cursor >= pos) {
            ++this.m_Cursor;
        }
        this.draw();
    }

    private void removeCharAt(int pos) throws IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.removeCharAt(pos);
        if (this.m_Cursor > pos) {
            --this.m_Cursor;
        }
        this.draw();
    }

    private void insertStringAt(int pos, String str) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(str.length());
        for (int i = 0; i < str.length(); ++i) {
            this.m_Buffer.insertCharAt(pos, str.charAt(i));
            ++this.m_Cursor;
        }
        this.draw();
    }

    public void append(char ch) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(1);
        this.m_Buffer.append(ch);
        ++this.m_Cursor;
        this.m_IO.write(ch);
    }

    public void append(String str) throws BufferOverflowException, IOException {
        this.storeSize();
        this.m_Buffer.ensureSpace(str.length());
        for (int i = 0; i < str.length(); ++i) {
            this.m_Buffer.append(str.charAt(i));
            ++this.m_Cursor;
        }
        this.m_IO.write(str);
    }

    public int getCursorPosition() {
        return this.m_Cursor;
    }

    public void setCursorPosition(int pos) {
        this.m_Cursor = this.m_Buffer.size() < pos ? this.m_Buffer.size() : pos;
    }

    private char getLastRead() {
        return this.m_LastRead;
    }

    private void setLastRead(char ch) {
        this.m_LastRead = ch;
    }

    public boolean isInInsertMode() {
        return this.m_InsertMode;
    }

    public void setInsertMode(boolean b) {
        this.m_InsertMode = b;
    }

    public boolean isHardwrapped() {
        return this.m_HardWrapped;
    }

    public void setHardwrapped(boolean b) {
        this.m_HardWrapped = b;
    }

    public int run() throws IOException {
        int in = 0;
        while (true) {
            in = this.m_IO.read();
            this.m_LastCursPos = this.m_Cursor;
            switch (in) {
                case 1004: {
                    if (this.moveLeft()) break;
                    return in;
                }
                case 1003: {
                    if (this.moveRight()) break;
                    return in;
                }
                case 1303: {
                    try {
                        if (this.m_Cursor == 0) {
                            return in;
                        }
                        this.removeCharAt(this.m_Cursor - 1);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        this.m_IO.bell();
                    }
                    break;
                }
                case 1302: {
                    try {
                        this.removeCharAt(this.m_Cursor);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        this.m_IO.bell();
                    }
                    break;
                }
                case 10: 
                case 1001: 
                case 1002: 
                case 1301: {
                    return in;
                }
                default: {
                    try {
                        this.handleCharInput(in);
                        break;
                    }
                    catch (BufferOverflowException boex) {
                        this.setLastRead((char)in);
                        return in;
                    }
                }
            }
            this.m_IO.flush();
        }
    }

    public void draw() throws IOException {
        this.m_IO.moveLeft(this.m_LastCursPos);
        this.m_IO.eraseToEndOfLine();
        this.m_IO.write(this.m_Buffer.toString());
        if (this.m_Cursor < this.m_Buffer.size()) {
            this.m_IO.moveLeft(this.m_Buffer.size() - this.m_Cursor);
        }
    }

    private boolean moveRight() throws IOException {
        if (this.m_Cursor < this.m_Buffer.size()) {
            ++this.m_Cursor;
            this.m_IO.moveRight(1);
            return true;
        }
        return false;
    }

    private boolean moveLeft() throws IOException {
        if (this.m_Cursor > 0) {
            --this.m_Cursor;
            this.m_IO.moveLeft(1);
            return true;
        }
        return false;
    }

    private boolean isCursorAtEnd() {
        return this.m_Cursor == this.m_Buffer.size();
    }

    private void handleCharInput(int ch) throws BufferOverflowException, IOException {
        if (this.isCursorAtEnd()) {
            this.append((char)ch);
        } else if (this.isInInsertMode()) {
            try {
                this.insertCharAt(this.m_Cursor, (char)ch);
            }
            catch (BufferOverflowException ex) {
                this.m_IO.bell();
            }
        } else {
            this.setCharAt(this.m_Cursor, (char)ch);
        }
    }

    private void storeSize() {
        this.m_LastSize = this.m_Buffer.size();
    }

    class Buffer
    extends CharBuffer {
        public Buffer(int size) {
            super(size);
        }
    }
}

