/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.zip;

import com.liferay.portal.kernel.io.FileCacheOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriter
implements Serializable {
    private static final Log _log = LogFactoryUtil.getLog(ZipWriter.class);
    private static final int _BUFFER = 2048;
    private FileCacheOutputStream _fcos;
    private ZipOutputStream _zos;
    private byte[] _data = new byte[2048];

    public ZipWriter() throws IOException {
        this._fcos = new FileCacheOutputStream();
        this._zos = new ZipOutputStream(this._fcos);
    }

    public void addEntry(String name, byte[] bytes) throws IOException {
        this.addEntry(name, new ByteArrayInputStream(bytes));
    }

    public void addEntry(String name, InputStream is) throws IOException {
        int count;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (is == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Adding " + name);
        }
        ZipEntry entry = new ZipEntry(name);
        this._zos.putNextEntry(entry);
        BufferedInputStream bis = new BufferedInputStream(is, 2048);
        while ((count = bis.read(this._data, 0, 2048)) != -1) {
            this._zos.write(this._data, 0, count);
        }
        bis.close();
        this._zos.closeEntry();
    }

    public void addEntry(String name, String s) throws IOException {
        this.addEntry(name, s.getBytes());
    }

    public void addEntry(String name, StringBuilder sb) throws IOException {
        this.addEntry(name, sb.toString());
    }

    public byte[] finish() throws IOException {
        this._zos.close();
        return this._fcos.getBytes();
    }

    public FileCacheOutputStream finishWithStream() throws IOException {
        this._zos.close();
        return this._fcos;
    }
}

