/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.portlet.BaseFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.PortletMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RSSFriendlyURLMapper
extends BaseFriendlyURLMapper {
    @Override
    public String buildPath(LiferayPortletURL portletURL) {
        String friendlyURLPath = null;
        boolean rss = GetterUtil.getBoolean(portletURL.getParameter("rss"));
        if (rss) {
            friendlyURLPath = "/" + this.getMapping() + "/rss";
            portletURL.addParameterIncludedInPath("rss");
        }
        if (Validator.isNotNull(friendlyURLPath)) {
            portletURL.addParameterIncludedInPath("p_p_id");
        }
        return friendlyURLPath;
    }

    @Override
    public void populateParams(String friendlyURLPath, Map<String, String[]> params) {
        int x = friendlyURLPath.indexOf("/", 1);
        if (x == -1) {
            return;
        }
        String rss = friendlyURLPath.substring(x + 1);
        if (!rss.equals("rss")) {
            return;
        }
        this.addParam(params, "p_p_id", this.getPortletId());
        this.addParam(params, "p_p_lifecycle", "0");
        this.addParam(params, "p_p_state", LiferayWindowState.EXCLUSIVE);
        this.addParam(params, "p_p_mode", PortletMode.VIEW);
    }
}

