/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class ArrayDispatcherDestination
extends BaseDestination {
    private static Log _log = LogFactoryUtil.getLog(BaseDestination.class);
    private MessageListener[] _listeners = new MessageListener[0];

    public ArrayDispatcherDestination(String name) {
        super(name);
    }

    public ArrayDispatcherDestination(String name, int workersCoreSize, int workersMaxSize) {
        super(name, workersCoreSize, workersMaxSize);
    }

    public synchronized void register(MessageListener listener) {
        listener = new InvokerMessageListener(listener);
        HashSet<MessageListener> listeners = new HashSet<MessageListener>(Arrays.asList(this._listeners));
        listeners.add(listener);
        this._listeners = listeners.toArray(new MessageListener[listeners.size()]);
        this.setListenerCount(listeners.size());
    }

    public void send(Message message) {
        if (this._listeners.length == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug("No listeners for destination " + this.getName());
            }
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        if (threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("Destination " + this.getName() + " is shutdown and cannot " + "receive more messages");
        }
        this.dispatch(this._listeners, message);
    }

    public synchronized boolean unregister(MessageListener listener) {
        listener = new InvokerMessageListener(listener);
        List listeners = ListUtil.fromArray(this._listeners);
        boolean value = listeners.remove(listener);
        if (value) {
            this._listeners = listeners.toArray(new MessageListener[listeners.size()]);
            this.setListenerCount(listeners.size());
        }
        return value;
    }

    protected abstract void dispatch(MessageListener[] var1, Message var2);
}

