/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.basev1;

import com.viettel.mmserver.basev1.MmProcess;
import com.viettel.mmserver.basev1.TaskInforMBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class TaskInfo
extends StandardMBean
implements TaskInforMBean {
    public static final int HOUR_TYPE = 1;
    public static final int DAILY_TYPE = 2;
    public static final int MONTHLY_TYPE = 3;
    public static final int ONCE_TYPE = 5;
    public static final int PERIOD_TYPE = 6;
    private Integer id;
    private String classPath;
    private String jarPath = null;
    private MmProcess mmProcess;
    private String name;
    private String param;
    private String type;
    private RepeatType repeatType;
    private RunningState runningState;
    private boolean[] taskDone;
    private List<Calendar> taskTimes = new ArrayList<Calendar>();
    private Calendar lastRun = null;
    private int interval = -1;

    public TaskInfo() throws NotCompliantMBeanException {
        super(TaskInforMBean.class);
        this.runningState = RunningState.READY;
        this.repeatType = RepeatType.UNDEFINED;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public MmProcess getMmProcess() {
        return this.mmProcess;
    }

    public void setMmProcess(MmProcess mmProcess) {
        this.mmProcess = mmProcess;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String repeatType) {
        this.type = repeatType;
    }

    public void addTaskTime(String tasktime) {
        this.taskTimes.add(this.convertStringToDate(tasktime));
    }

    public synchronized void removeTaskTimeString(int i) {
        if (i > -1 && i < this.taskTimes.size()) {
            this.taskTimes.remove(i);
            if (this.repeatType == RepeatType.PERIOD) {
                this.runningState = RunningState.READY;
                this.lastRun = null;
            } else {
                int j;
                boolean[] temp = new boolean[this.taskTimes.size()];
                for (j = 0; j < i; ++j) {
                    temp[j] = this.taskDone[j];
                }
                for (j = i + 1; j < this.taskTimes.size() + 1; ++j) {
                    temp[j - 1] = this.taskDone[j];
                }
                this.taskDone = temp;
            }
        }
    }

    public String[] getTaskTimeString() {
        String[] temp = new String[this.taskTimes.size()];
        block7: for (int i = 0; i < temp.length; ++i) {
            switch (this.repeatType) {
                case HOUR: {
                    temp[i] = this.taskTimes.get(i).get(12) + ":" + this.taskTimes.get(i).get(13);
                    continue block7;
                }
                case DAILY: {
                    temp[i] = this.taskTimes.get(i).get(11) + ":" + this.taskTimes.get(i).get(12) + ":" + this.taskTimes.get(i).get(13);
                    continue block7;
                }
                case MONTHLY: {
                    temp[i] = this.taskTimes.get(i).get(5) + ":" + this.taskTimes.get(i).get(11) + ":" + this.taskTimes.get(i).get(12) + ":" + this.taskTimes.get(i).get(13);
                    continue block7;
                }
                case ONCE: {
                    temp[i] = this.taskTimes.get(i).get(1) + ":" + this.taskTimes.get(i).get(2) + ":" + this.taskTimes.get(i).get(5) + ":" + this.taskTimes.get(i).get(11) + ":" + this.taskTimes.get(i).get(12) + ":" + this.taskTimes.get(i).get(13);
                    continue block7;
                }
                case PERIOD: {
                    temp[i] = this.taskTimes.get(i).get(1) + ":" + this.taskTimes.get(i).get(2) + ":" + this.taskTimes.get(i).get(5) + ":" + this.taskTimes.get(i).get(11) + ":" + this.taskTimes.get(i).get(12) + ":" + this.taskTimes.get(i).get(13) + ":" + this.interval;
                    continue block7;
                }
            }
        }
        return temp;
    }

    public synchronized String addTaskTimeString(String tasktime) {
        String re = "Wrong format";
        Calendar date = Calendar.getInstance();
        String[] result = tasktime.trim().split(":");
        switch (result.length - 1) {
            case 1: {
                if (this.repeatType == RepeatType.HOUR) break;
                return re;
            }
            case 2: {
                if (this.repeatType == RepeatType.DAILY) break;
                return re;
            }
            case 3: {
                if (this.repeatType == RepeatType.MONTHLY) break;
                return re;
            }
            case 5: {
                if (this.repeatType == RepeatType.ONCE) break;
                return re;
            }
            case 6: {
                if (this.repeatType == RepeatType.PERIOD) break;
                return re;
            }
            default: {
                return re;
            }
        }
        if (this.repeatType != RepeatType.PERIOD) {
            int i;
            this.taskTimes.add(this.convertStringToDate(tasktime));
            boolean[] temp = new boolean[this.taskTimes.size()];
            for (i = 0; i < temp.length; ++i) {
                temp[i] = false;
            }
            for (i = 0; i < this.taskDone.length; ++i) {
                temp[i] = this.taskDone[i];
            }
            this.taskDone = temp;
        } else if (this.taskTimes.size() == 0) {
            this.taskTimes.add(this.convertStringToDate(tasktime));
        } else {
            return "Can't add more schedule";
        }
        return "OK";
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder("\n" + indent + "<taskinfo id=\"" + this.getId() + "\" type=\"" + this.getType() + "\">\n");
        sb.append(indent + "   <name>" + this.getName() + "</name>\n");
        sb.append(indent + "   <classPath>" + this.getClassPath() + "</classPath>\n");
        sb.append(indent + "   <jarPath>" + this.getJarPath() + "</jarPath>\n");
        sb.append(indent + "   <param>" + this.getParam() + "</param>\n");
        for (Calendar time : this.taskTimes) {
            sb.append(indent + "   <time>" + time.get(11) + ":" + time.get(12) + "</time>\n");
            if (this.repeatType != RepeatType.PERIOD) continue;
            sb.append(indent + "   <interval>" + this.interval + "</interval>\n");
        }
        sb.append(indent + "</taskinfo>\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public Calendar convertStringToDate(String aStr) {
        Calendar date = Calendar.getInstance();
        String[] result = aStr.trim().split(":");
        switch (result.length - 1) {
            case 1: {
                date.set(12, Integer.parseInt(result[0]));
                date.set(13, Integer.parseInt(result[1]));
                this.repeatType = RepeatType.HOUR;
                return date;
            }
            case 2: {
                date.set(11, Integer.parseInt(result[0]));
                date.set(12, Integer.parseInt(result[1]));
                date.set(13, Integer.parseInt(result[2]));
                this.repeatType = RepeatType.DAILY;
                return date;
            }
            case 3: {
                date.set(5, Integer.parseInt(result[0]));
                date.set(11, Integer.parseInt(result[1]));
                date.set(12, Integer.parseInt(result[2]));
                date.set(13, Integer.parseInt(result[3]));
                this.repeatType = RepeatType.MONTHLY;
                return date;
            }
            case 5: {
                date.set(1, Integer.parseInt(result[0]));
                date.set(2, Integer.parseInt(result[1]) - 1);
                date.set(5, Integer.parseInt(result[2]));
                date.set(11, Integer.parseInt(result[3]));
                date.set(12, Integer.parseInt(result[4]));
                date.set(13, Integer.parseInt(result[5]));
                this.repeatType = RepeatType.ONCE;
                return date;
            }
            case 6: {
                date.set(1, Integer.parseInt(result[0]));
                date.set(2, Integer.parseInt(result[1]) - 1);
                date.set(5, Integer.parseInt(result[2]));
                date.set(11, Integer.parseInt(result[3]));
                date.set(12, Integer.parseInt(result[4]));
                date.set(13, Integer.parseInt(result[5]));
                this.repeatType = RepeatType.PERIOD;
                this.interval = Integer.parseInt(result[6]);
                return date;
            }
        }
        return null;
    }

    public boolean isTimeToRun() {
        switch (this.repeatType) {
            case PERIOD: {
                Calendar temp = Calendar.getInstance();
                if (this.lastRun == null && this.taskTimes.size() > 0) {
                    Calendar cal = this.taskTimes.get(0);
                    if (cal.compareTo(temp) > 0) break;
                    long lCal = cal.getTimeInMillis();
                    lCal += (long)(this.interval * (int)((temp.getTimeInMillis() - lCal) / (long)this.interval));
                    cal.setTimeInMillis(lCal);
                    this.lastRun = (Calendar)cal.clone();
                    if (cal.compareTo(temp) != 0) break;
                    return true;
                }
                if (this.lastRun == null) break;
                Calendar cal = (Calendar)this.lastRun.clone();
                cal.add(14, this.interval);
                if (cal.compareTo(temp) <= 0) {
                    this.lastRun = (Calendar)temp.clone();
                    if (this.runningState == RunningState.READY) {
                        return true;
                    }
                }
                return false;
            }
            case MONTHLY: {
                Calendar temp = Calendar.getInstance();
                if (this.lastRun == null || this.lastRun.get(2) != temp.get(2)) {
                    for (boolean b : this.taskDone = new boolean[this.taskTimes.size()]) {
                        b = false;
                    }
                    this.lastRun = (Calendar)temp.clone();
                }
                for (int i = 0; i < this.taskTimes.size(); ++i) {
                    Calendar cal;
                    if (this.taskDone[i] || (cal = this.taskTimes.get(i)).get(12) != temp.get(12) || cal.get(11) != temp.get(11) || cal.get(5) != temp.get(5) || this.runningState != RunningState.READY) continue;
                    this.taskDone[i] = true;
                    this.lastRun = (Calendar)temp.clone();
                    return true;
                }
                break;
            }
            case DAILY: {
                Calendar temp = Calendar.getInstance();
                if (this.lastRun == null || this.lastRun.get(5) != temp.get(5)) {
                    for (boolean b : this.taskDone = new boolean[this.taskTimes.size()]) {
                        b = false;
                    }
                    this.lastRun = (Calendar)temp.clone();
                }
                for (int i = 0; i < this.taskTimes.size(); ++i) {
                    Calendar cal;
                    if (this.taskDone[i] || (cal = this.taskTimes.get(i)).get(12) != temp.get(12) || cal.get(11) != temp.get(11) || this.runningState != RunningState.READY) continue;
                    this.taskDone[i] = true;
                    this.lastRun = (Calendar)temp.clone();
                    return true;
                }
                break;
            }
            case HOUR: {
                Calendar temp = Calendar.getInstance();
                if (this.lastRun == null || this.lastRun.get(11) != temp.get(11)) {
                    for (boolean b : this.taskDone = new boolean[this.taskTimes.size()]) {
                        b = false;
                    }
                    this.lastRun = (Calendar)temp.clone();
                }
                for (int i = 0; i < this.taskTimes.size(); ++i) {
                    Calendar cal;
                    if (this.taskDone[i] || (cal = this.taskTimes.get(i)).get(12) != temp.get(12) || this.runningState != RunningState.READY) continue;
                    this.taskDone[i] = true;
                    this.lastRun = (Calendar)temp.clone();
                    return true;
                }
                break;
            }
            case ONCE: {
                Calendar temp = Calendar.getInstance();
                if (this.lastRun == null) {
                    for (boolean b : this.taskDone = new boolean[this.taskTimes.size()]) {
                        b = false;
                    }
                    this.lastRun = (Calendar)temp.clone();
                }
                for (int i = 0; i < this.taskTimes.size(); ++i) {
                    if (this.taskDone[i]) continue;
                    Calendar cal = this.taskTimes.get(i);
                    cal.set(14, temp.get(14));
                    cal.set(13, temp.get(13));
                    if (cal.compareTo(temp) != 0 || this.runningState != RunningState.READY) continue;
                    this.taskDone[i] = true;
                    this.lastRun = (Calendar)temp.clone();
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public RunningState getRunningState() {
        return this.runningState;
    }

    public void setRunningState(RunningState runningState) {
        this.runningState = runningState;
    }

    protected String getDescription(MBeanInfo info) {
        return "M\u00f4 t\u1ea3 th\u00f4ng tin v\u1ec1 m\u1ed9t task bao g\u1ed3m danh s\u00e1ch th\u1eddi \u0111i\u1ec3m ch\u1ea1y, ki\u1ec3u l\u1eb7p, classpath...";
    }

    protected String getDescription(MBeanOperationInfo info) {
        MBeanParameterInfo[] params = info.getSignature();
        Object[] signature = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            signature[i] = params[i].getType();
        }
        Object[] methodSignature = new String[]{String.class.getName()};
        if (info.getName().equals("removeTaskTimeString") && Arrays.equals(signature, methodSignature)) {
            return "X\u00f3a m\u1ed9t th\u1eddi \u0111i\u1ec3m ch\u1ea1y kh\u1ecfi danh s\u00e1ch th\u1eddi \u0111i\u1ec3m ch\u1ea1y";
        }
        if (info.getName().equals("addTaskTimeString") && Arrays.equals(signature, methodSignature)) {
            switch (this.repeatType) {
                case PERIOD: {
                    return "Th\u00eam m\u1ed9t l\u1ecbch ch\u1ea1y v\u00e0o danh s\u00e1ch l\u1ecbch ch\u1ea1y (v\u00ed d\u1ee5 yyyy:mm:dd:hh:mm:ss:interval)";
                }
                case DAILY: {
                    return "Th\u00eam m\u1ed9t l\u1ecbch ch\u1ea1y v\u00e0o danh s\u00e1ch l\u1ecbch ch\u1ea1y (v\u00ed d\u1ee5 hh:mm:ss)";
                }
                case MONTHLY: {
                    return "Th\u00eam m\u1ed9t l\u1ecbch ch\u1ea1y v\u00e0o danh s\u00e1ch l\u1ecbch ch\u1ea1y (v\u00ed d\u1ee5 dd:hh:mm:ss)";
                }
                case HOUR: {
                    return "Th\u00eam m\u1ed9t l\u1ecbch ch\u1ea1y v\u00e0o danh s\u00e1ch l\u1ecbch ch\u1ea1y (v\u00ed d\u1ee5 mm:ss)";
                }
                case ONCE: {
                    return "Th\u00eam m\u1ed9t l\u1ecbch ch\u1ea1y v\u00e0o danh s\u00e1ch l\u1ecbch ch\u1ea1y (v\u00ed d\u1ee5 yyyy:mm:dd:hh:mm:ss)";
                }
            }
        }
        if (info.getName().equals("toString")) {
            return "N\u1ed9i dung c\u1ee7a Task";
        }
        return null;
    }

    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("addTaskTimeString")) {
            switch (sequence) {
                case 0: {
                    return "Chu\u1ed7i k\u00fd t\u1ef1 m\u00f4 t\u1ea3 m\u1ed9t th\u1eddi \u0111i\u1ec3m \u0111\u1ec3 th\u00eam v\u00e0o";
                }
            }
            return null;
        }
        if (op.getName().equals("removeTaskTimeString")) {
            switch (sequence) {
                case 0: {
                    return "ID c\u1ee7a task time";
                }
            }
            return null;
        }
        return null;
    }

    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("addTaskTimeString")) {
            switch (sequence) {
                case 0: {
                    return "tasktime";
                }
            }
            return null;
        }
        if (op.getName().equals("removeTaskTimeString")) {
            switch (sequence) {
                case 0: {
                    return "tasktimeID";
                }
            }
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepeatType {
        UNDEFINED,
        ONCE,
        HOUR,
        DAILY,
        MONTHLY,
        PERIOD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunningState {
        READY,
        RUNNING;

    }
}

