/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.basev1;

import com.viettel.mmserver.agent.MMbeanServer;
import com.viettel.mmserver.base.Log;
import com.viettel.mmserver.basev1.BooleanLock;
import com.viettel.mmserver.basev1.MmProcess;
import com.viettel.mmserver.basev1.ProcessManagerv1;
import com.viettel.mmserver.basev1.TaskInfo;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.log4j.Logger;

public abstract class MmProcessAbstract
implements Runnable,
MmProcess,
DynamicMBean,
NotificationEmitter {
    private static int allId = 0;
    private Integer id;
    private String dClassName = this.getClass().getName();
    private Thread internalThread;
    private volatile boolean running;
    private int status = 1;
    private final BooleanLock suspendRequested;
    private final BooleanLock internalSuspended;
    private final String threadName;
    protected Logger logger;
    private TaskInfo taskinfo = null;
    public static final String TYPE = "process.status";
    private NotificationBroadcasterSupport notificationHandler;
    private String mbeanName = "";
    private String dDescription;
    private MBeanAttributeInfo[] dAttributes;
    private MBeanConstructorInfo[] dConstructors;
    private MBeanOperationInfo[] dOperations;
    private MBeanNotificationInfo[] dNotifications;
    private MBeanInfo dMBeanInfo;

    private MmProcessAbstract(boolean bstart, String aThreadName) throws NotCompliantMBeanException {
        this.buildDynamicMBeanInfo();
        this.notificationHandler = new NotificationBroadcasterSupport();
        this.id = ++allId;
        this.threadName = aThreadName + "." + this.id;
        this.suspendRequested = new BooleanLock(false);
        this.internalSuspended = new BooleanLock(false);
        this.registerMangement();
        this.internalThread = new Thread(new Runnable(){

            public void run() {
                Log.info("internal thread start");
                if (MmProcessAbstract.this.preProcess()) {
                    MmProcessAbstract.this.performJob();
                }
                MmProcessAbstract.this.posProcess();
                Log.info("internal thread stopped");
            }
        }, this.threadName);
        if (bstart) {
            this.start();
            if (this.taskinfo != null) {
                this.taskinfo.setRunningState(TaskInfo.RunningState.RUNNING);
            }
        }
    }

    private MmProcessAbstract(boolean bstart, String aThreadName, String mbeanName) throws NotCompliantMBeanException {
        this.buildDynamicMBeanInfo();
        this.notificationHandler = new NotificationBroadcasterSupport();
        this.id = ++allId;
        this.mbeanName = mbeanName;
        this.threadName = aThreadName + "." + this.id;
        this.suspendRequested = new BooleanLock(false);
        this.internalSuspended = new BooleanLock(false);
        this.registerMangement();
        this.internalThread = new Thread((Runnable)this, this.threadName);
        if (bstart) {
            this.start();
            if (this.taskinfo != null) {
                this.taskinfo.setRunningState(TaskInfo.RunningState.RUNNING);
            }
        }
    }

    private void registerMangement() {
        ProcessManagerv1.getInstance().addMmProcess(this);
        if (this.mbeanName.equals("")) {
            this.mbeanName = "MMLib:type=ProcessManagerList,name=" + this.threadName;
        }
        try {
            MMbeanServer.getInstance().registerMBean(this, new ObjectName(this.mbeanName));
            this.logger = Logger.getLogger((String)this.mbeanName);
        }
        catch (Exception ex) {
            Log.warn("Register JMX error", ex);
        }
    }

    private void unRegisterMangement() {
        try {
            MMbeanServer.getInstance().unregisterMBean(new ObjectName(this.mbeanName));
        }
        catch (Exception ex) {
            Log.warn("Remove JMX error", ex);
        }
        ProcessManagerv1.getInstance().unManageProcess(this.getId());
        if (this.taskinfo != null) {
            this.taskinfo.setRunningState(TaskInfo.RunningState.READY);
        }
    }

    public MmProcessAbstract(String threadName) throws NotCompliantMBeanException {
        this(true, threadName);
    }

    public MmProcessAbstract(String threadName, String mbeanName) throws NotCompliantMBeanException {
        this(true, threadName, mbeanName);
    }

    public MmProcessAbstract(String name, boolean bstart) throws NotCompliantMBeanException {
        this(bstart, name);
    }

    public MmProcessAbstract(TaskInfo taskinfo) throws NotCompliantMBeanException {
        this(taskinfo.getName());
        this.taskinfo = taskinfo;
    }

    protected final void performJob() {
        while (this.running) {
            try {
                this.waitWhileSuspended();
            }
            catch (InterruptedException e) {
                Log.error("interrupted: " + e.getMessage());
                if (this.running) continue;
            }
            try {
                this.elmProcess();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.error("interrupted: " + e.getMessage());
            }
        }
        Log.info("internal thread leave performJob");
    }

    protected boolean preProcess() {
        return true;
    }

    protected void posProcess() {
    }

    protected abstract void elmProcess() throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhileSuspended() throws InterruptedException {
        BooleanLock booleanLock = this.suspendRequested;
        synchronized (booleanLock) {
            try {
                this.internalSuspended.setValue(true);
                this.suspendRequested.waitUntilFalse(0L);
                Object var3_2 = null;
                this.internalSuspended.setValue(false);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.internalSuspended.setValue(false);
                throw throwable;
            }
        }
    }

    public final void setThreadName(String name) {
        this.internalThread.setName(name);
    }

    public final String getThreadName() {
        return this.internalThread.getName();
    }

    public final synchronized void start() {
        Log.info("requestStart");
        if (!this.running) {
            this.running = true;
            this.internalThread = new Thread((Runnable)this, this.threadName);
            this.internalThread.start();
            this.setProcessStatus(0);
            this.logger.info((Object)(this.threadName + " process  is started"));
            Notification notification = new Notification(TYPE, (Object)this.getProcessStatus(), 0L, this.getThreadName() + " started");
            this.notificationHandler.sendNotification(notification);
        } else {
            this.logger.info((Object)(this.threadName + " process  is started"));
        }
    }

    public void restart() {
        this.stop();
        this.start();
    }

    protected int getProcessStatus() {
        return this.status;
    }

    protected void setProcessStatus(int status) {
        this.status = status;
    }

    public boolean isStopRequested() {
        return this.status == 2 || this.status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stop() {
        if (this.running) {
            block7: {
                this.setProcessStatus(2);
                this.running = false;
                if (this.internalThread != null) {
                    this.internalThread.interrupt();
                }
                try {
                    block6: {
                        try {
                            if (this.internalThread == null || !this.internalThread.isAlive()) break block6;
                            this.logger.info((Object)("waiting " + this.threadName + " process stop..."));
                            this.internalThread.join();
                        }
                        catch (InterruptedException ex) {
                            this.logger.error((Object)("stop process exception:" + ex));
                            Object var3_2 = null;
                            this.logger.info((Object)(this.threadName + " process is stopped"));
                            break block7;
                        }
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.logger.info((Object)(this.threadName + " process is stopped"));
                    throw throwable;
                }
                this.logger.info((Object)(this.threadName + " process is stopped"));
            }
            this.setProcessStatus(1);
            this.onRequestStop();
            Notification notification = new Notification(TYPE, (Object)this.getProcessStatus(), 0L, this.getThreadName() + " stopped");
            this.notificationHandler.sendNotification(notification);
        }
    }

    public String loadParams() {
        return "";
    }

    public String saveParams(String newConfig) {
        return "";
    }

    public void onRequestStop() {
    }

    public final void suspend() {
        Log.info("requestSuspend");
        this.suspendRequested.setValue(true);
    }

    public final void resume() {
        Log.info("requestResume");
        this.suspendRequested.setValue(false);
    }

    public final boolean isAlive() {
        return this.internalThread.isAlive();
    }

    public Thread.State getState() {
        return Thread.currentThread().getState();
    }

    public Integer getId() {
        return this.id;
    }

    public TaskInfo getTaskinfo() {
        return this.taskinfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MmProcess: " + this.getThreadName());
        sb.append("\nprocess id:" + this.getId());
        sb.append("\nprocess state:" + this.getState().toString());
        return sb.toString();
    }

    public void run() {
        Log.info("Thread " + this.threadName + " start");
        if (this.preProcess()) {
            this.performJob();
        }
        this.posProcess();
        this.setProcessStatus(1);
        Log.info("internal thread stopped");
    }

    public String getInfor() {
        StringBuffer buff = new StringBuffer();
        buff.append("Thread Name:" + this.threadName);
        buff.append("\r\nStatus:" + this.getStatusDesc());
        return buff.toString();
    }

    public String getStatusDesc() {
        switch (this.status) {
            case 0: {
                return "running";
            }
            case 1: {
                return "stopped";
            }
        }
        return "stopping";
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notificationHandler.removeNotificationListener(listener, filter, handback);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notificationHandler.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.dNotifications;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationHandler.removeNotificationListener(listener);
    }

    protected MBeanNotificationInfo[] buildNotifications() {
        this.dNotifications = new MBeanNotificationInfo[1];
        this.dNotifications[0] = new MBeanNotificationInfo(new String[]{"Process Status"}, Notification.class.getName(), "notification when the status of process changed");
        return this.dNotifications;
    }

    public Object getAttribute(String attributeNname) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeNname == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (attributeNname.equals("ThreadName")) {
            return this.getThreadName();
        }
        if (attributeNname.equals("Status")) {
            return this.getProcessStatus();
        }
        throw new AttributeNotFoundException("Cannot find " + attributeNname + " attribute in " + this.dClassName);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        if (name.equals("ThreadName")) {
            try {
                if (!Class.forName("java.lang.String").isAssignableFrom(value.getClass())) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + value.getClass().getName() + " object, String expected");
                }
                this.setThreadName((String)value);
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)("Error in SetAttribue: " + e));
            }
        } else {
            if (name.equals("Status")) {
                throw new AttributeNotFoundException("Cannot set attribute " + name + " because it is read-only");
            }
            throw new AttributeNotFoundException("Attribute " + name + " not found in " + this.getClass().getName());
        }
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (AttributeNotFoundException e) {
                this.logger.error((Object)"Error in Get Attributes");
                this.logger.error((Object)e);
                continue;
            }
            catch (MBeanException e) {
                this.logger.error((Object)"Error in Get Attributes");
                this.logger.error((Object)e);
                continue;
            }
            catch (ReflectionException e) {
                this.logger.error((Object)"Error in Get Attributes");
                this.logger.error((Object)e);
            }
        }
        return resultList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes cannot be null"), "Cannot invoke a setter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        for (Attribute attr : attributes) {
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (AttributeNotFoundException e) {
                this.logger.error((Object)"Error in SetAttributes");
                this.logger.error((Object)e);
            }
            catch (InvalidAttributeValueException e) {
                this.logger.error((Object)"Error in SetAttributes");
                this.logger.error((Object)e);
            }
            catch (MBeanException e) {
                this.logger.error((Object)"Error in SetAttributes");
                this.logger.error((Object)e);
            }
            catch (ReflectionException e) {
                this.logger.error((Object)"Error in SetAttributes");
                this.logger.error((Object)e);
            }
        }
        return resultList;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("start")) {
            this.start();
            return null;
        }
        if (operationName.equals("stop")) {
            this.stop();
            return null;
        }
        if (operationName.equals("restart")) {
            this.restart();
            return null;
        }
        if (operationName.equals("getInfor")) {
            return this.getInfor();
        }
        if (operationName.equals("loadParams")) {
            return this.loadParams();
        }
        if (operationName.equals("saveParams")) {
            String newConfig = (String)params[0];
            return this.saveParams(newConfig);
        }
        throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.dClassName);
    }

    public MBeanInfo getMBeanInfo() {
        return this.dMBeanInfo;
    }

    protected MBeanAttributeInfo[] buildAttributes() {
        ArrayList<MBeanAttributeInfo> v = new ArrayList<MBeanAttributeInfo>();
        v.add(new MBeanAttributeInfo("ThreadName", "java.lang.String", "The name of thread", true, true, false));
        v.add(new MBeanAttributeInfo("Status", "java.lang.Integer", "The status of thread, 0 - running 1-stopping 2- stopped", true, false, false));
        v.add(new MBeanAttributeInfo("Running", "java.lang.Boolean", "The running status", true, false, true));
        v.add(new MBeanAttributeInfo("Priority", "java.lang.Integer", "Priority of thread value range 1-10", true, true, false));
        return v.toArray(new MBeanAttributeInfo[v.size()]);
    }

    protected MBeanOperationInfo[] buildOperations() {
        ArrayList<MBeanOperationInfo> v = new ArrayList<MBeanOperationInfo>();
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        v.add(new MBeanOperationInfo("start", "start service", params, "void", 1));
        v.add(new MBeanOperationInfo("stop", "stop service", params, "void", 1));
        v.add(new MBeanOperationInfo("restart", "stop service", params, "void", 1));
        v.add(new MBeanOperationInfo("getInfor", "get configuration information and runtime state of this service", params, "java.lang.String", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("dump", "java.lang.Boolean", "boolean value indicate track thread or not")};
        v.add(new MBeanOperationInfo("setDump", "set dumping status of current thread", params, "void", 1));
        params = new MBeanParameterInfo[]{};
        v.add(new MBeanOperationInfo("loadParams", "load params", params, "java.lang.String", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("newConfig", "java.lang.String", "The String express new config")};
        v.add(new MBeanOperationInfo("saveParams", "save params", params, "java.lang.String", 1));
        return v.toArray(new MBeanOperationInfo[v.size()]);
    }

    protected MBeanConstructorInfo[] buildConstructors() {
        ArrayList<MBeanConstructorInfo> v = new ArrayList<MBeanConstructorInfo>();
        Constructor<?>[] constructors = this.getClass().getConstructors();
        if (constructors != null && constructors.length > 0) {
            v.add(new MBeanConstructorInfo("Constructs a service object", constructors[0]));
        }
        return v.toArray(new MBeanConstructorInfo[v.size()]);
    }

    protected void buildDynamicMBeanInfo() {
        this.dDescription = "The process which run in a separator thread";
        this.dAttributes = this.buildAttributes();
        this.dConstructors = this.buildConstructors();
        this.dOperations = this.buildOperations();
        this.dNotifications = this.buildNotifications();
        this.dMBeanInfo = new MBeanInfo(this.dClassName, this.dDescription, this.dAttributes, this.dConstructors, this.dOperations, this.dNotifications);
    }
}

