/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.db.sql;

import com.mchange.lang.ThrowableUtils;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SqlUtils {
    static final DateFormat tsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");

    public static String escapeBadSqlPatternChars(String s) {
        StringBuffer sb = new StringBuffer(s);
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            if (sb.charAt(i) != '\'') continue;
            sb.insert(i, '\'');
            ++len;
            i += 2;
        }
        return sb.toString();
    }

    public static String escapeAsTimestamp(Date date) {
        return "{ts '" + tsdf.format(date) + "'}";
    }

    public static SQLException toSQLException(Throwable t) {
        if (t instanceof SQLException) {
            return (SQLException)t;
        }
        t.printStackTrace();
        return new SQLException(ThrowableUtils.extractStackTrace(t));
    }

    private SqlUtils() {
    }
}

