/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolParameter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.protocols.BasicTCP;
import org.jgroups.protocols.TCPPING;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UDP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.ResourceManager;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class SharedTransportTest
extends ChannelTestBase {
    private JChannel a;
    private JChannel b;
    private JChannel c;
    private MyReceiver r1;
    private MyReceiver r2;
    private MyReceiver r3;
    static final String SINGLETON_1 = "singleton-1";
    static final String SINGLETON_2 = "singleton-2";

    @AfterMethod
    protected void tearDown() throws Exception {
        Util.close(this.c, this.b, this.a);
        this.r3 = null;
        this.r2 = null;
        this.r1 = null;
    }

    public void testCreationNonSharedTransport() throws Exception {
        this.a = this.createChannel(true);
        this.a.connect("SharedTransportTest.testCreationNonSharedTransport");
        View view = this.a.getView();
        System.out.println("view = " + view);
        assert (view.size() == 1);
    }

    public void testCreationOfDuplicateCluster() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.b = this.createSharedChannel(SINGLETON_1);
        this.a.connect("x");
        try {
            this.b.connect("x");
            assert (false) : "b should not be able to join cluster 'x' as a has already joined it";
        }
        catch (Exception ex) {
            System.out.println("b was not able to join the same cluster (\"x\") as expected");
        }
    }

    public void testView() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.b = this.createSharedChannel(SINGLETON_2);
        this.a.setReceiver(new MyReceiver(SINGLETON_1));
        this.b.setReceiver(new MyReceiver(SINGLETON_2));
        this.a.connect("x");
        this.b.connect("x");
        View view = this.a.getView();
        assert (view.size() == 2);
        view = this.b.getView();
        assert (view.size() == 2);
    }

    public void testView2() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.b = this.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("first-channel"));
        this.b.setReceiver(new MyReceiver("second-channel"));
        this.a.connect("x");
        this.b.connect("y");
        View view = this.a.getView();
        assert (view.size() == 1);
        view = this.b.getView();
        assert (view.size() == 1);
    }

    public void testView3() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.b = this.createSharedChannel(SINGLETON_1);
        this.c = this.createSharedChannel(SINGLETON_2);
        this.r1 = new MyReceiver("A::singleton-1");
        this.r2 = new MyReceiver("B::singleton-1");
        this.r3 = new MyReceiver("C::singleton-2");
        this.a.setReceiver(this.r1);
        this.b.setReceiver(this.r2);
        this.c.setReceiver(this.r3);
        this.a.connect("cluster-1");
        this.c.connect("cluster-1");
        View view = this.a.getView();
        assert (view.size() == 2);
        view = this.c.getView();
        assert (view.size() == 2);
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-1")));
        this.c.send(new Message(null, null, (Serializable)((Object)"msg-2")));
        Util.sleep(1000L);
        List<Message> list = this.r1.getList();
        assert (list.size() == 2);
        list = this.r3.getList();
        assert (list.size() == 2);
        this.r1.clear();
        this.r2.clear();
        this.r3.clear();
        this.b.connect("cluster-2");
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-3")));
        this.b.send(new Message(null, null, (Serializable)((Object)"msg-4")));
        this.c.send(new Message(null, null, (Serializable)((Object)"msg-5")));
        Util.sleep(1000L);
        list = this.r1.getList();
        assert (list.size() == 2);
        list = this.r2.getList();
        assert (list.size() == 1);
        list = this.r3.getList();
        assert (list.size() == 2);
    }

    public void testView4() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.r1 = new MyReceiver("A::singleton-1");
        this.a.setReceiver(this.r1);
        this.a.connect("cluster-X");
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-1")));
        Util.sleep(1000L);
        List<Message> list = this.r1.getList();
        assert (list.size() == 1);
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-2")));
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-3")));
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-4")));
        Util.sleep(1000L);
        list = this.r1.getList();
        assert (list.size() == 4);
    }

    public void testSharedTransportAndNonsharedTransport() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.b = this.createChannel();
        this.a.setReceiver(new MyReceiver("first-channel"));
        this.b.setReceiver(new MyReceiver("second-channel"));
        this.a.connect("x");
        this.b.connect("x");
        View view = this.a.getView();
        assert (view.size() == 2);
        view = this.b.getView();
        assert (view.size() == 2);
    }

    public void testCreationOfDifferentCluster() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.b = this.createSharedChannel(SINGLETON_2);
        this.a.connect("x");
        this.b.connect("x");
        View view = this.b.getView();
        System.out.println("b's view is " + view);
        assert (view.size() == 2);
    }

    public void testReferenceCounting() throws ChannelException {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.r1 = new MyReceiver("a");
        this.a.setReceiver(this.r1);
        this.b = this.createSharedChannel(SINGLETON_1);
        this.r2 = new MyReceiver("b");
        this.b.setReceiver(this.r2);
        this.c = this.createSharedChannel(SINGLETON_1);
        this.r3 = new MyReceiver("c");
        this.c.setReceiver(this.r3);
        this.a.connect("A");
        this.b.connect("B");
        this.c.connect("C");
        this.a.send(null, null, (Serializable)((Object)"message from a"));
        this.b.send(null, null, (Serializable)((Object)"message from b"));
        this.c.send(null, null, (Serializable)((Object)"message from c"));
        Util.sleep(500L);
        assert (this.r1.size() == 1);
        assert (this.r2.size() == 1);
        assert (this.r3.size() == 1);
        this.r1.clear();
        this.r2.clear();
        this.r3.clear();
        this.b.disconnect();
        System.out.println("\n");
        this.a.send(null, null, (Serializable)((Object)"message from a"));
        this.c.send(null, null, (Serializable)((Object)"message from c"));
        Util.sleep(500L);
        assert (this.r1.size() == 1) : "size should be 1 but is " + this.r1.size();
        assert (this.r3.size() == 1) : "size should be 1 but is " + this.r3.size();
        this.r1.clear();
        this.r3.clear();
        this.c.disconnect();
        System.out.println("\n");
        this.a.send(null, null, (Serializable)((Object)"message from a"));
        Util.sleep(500L);
        assert (this.r1.size() == 1);
    }

    public void testSimpleReCreation() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        this.a.disconnect();
        this.b = this.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(new MyReceiver("A'"));
        this.b.connect("A");
    }

    public void testCreationFollowedByDeletion() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        this.b = this.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(new MyReceiver("B"));
        this.b.connect("B");
        this.b.close();
        this.a.close();
    }

    public void test2ChannelsCreationFollowedByDeletion() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        this.b = this.createSharedChannel(SINGLETON_2);
        this.b.setReceiver(new MyReceiver("B"));
        this.b.connect("A");
        this.c = this.createSharedChannel(SINGLETON_2);
        this.c.setReceiver(new MyReceiver("C"));
        this.c.connect("B");
        this.c.send(null, null, (Serializable)((Object)"hello world from C"));
    }

    public void testReCreationWithSurvivingChannel() throws Exception {
        System.out.println("-- creating A");
        this.a = this.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        System.out.println("-- creating B");
        this.b = this.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(new MyReceiver("B"));
        this.b.connect("B");
        System.out.println("-- disconnecting A");
        this.a.disconnect();
        System.out.println("-- creating A'");
        this.c = this.createSharedChannel(SINGLETON_1);
        this.c.setReceiver(new MyReceiver("A'"));
        this.c.connect("A");
    }

    public void testShutdownOfTimer() throws Exception {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.b = this.createSharedChannel(SINGLETON_1);
        this.a.connect("x");
        this.b.connect("y");
        TimeScheduler timer1 = this.a.getProtocolStack().getTransport().getTimer();
        TimeScheduler timer2 = this.b.getProtocolStack().getTransport().getTimer();
        assert (timer1 == timer2);
        assert (!timer1.isShutdown());
        assert (!timer2.isShutdown());
        Util.sleep(500L);
        this.b.close();
        assert (!timer2.isShutdown());
        assert (!timer1.isShutdown());
        this.a.close();
        assert (timer2.isShutdown());
        assert (timer1.isShutdown());
    }

    public void testSendingOfMessagesAfterChannelClose() throws ChannelException {
        MyReceiver rec_a = new MyReceiver("A");
        MyReceiver rec_b = new MyReceiver("B");
        MyReceiver rec_c = new MyReceiver("C");
        System.out.println("-- creating A");
        this.a = this.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(rec_a);
        this.a.connect("A");
        System.out.println("-- creating B");
        this.b = this.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(rec_b);
        this.b.connect("B");
        System.out.println("-- creating C");
        this.c = this.createSharedChannel(SINGLETON_2);
        this.c.setReceiver(rec_c);
        this.c.connect("B");
        this.b.send(null, null, (Serializable)((Object)"first"));
        Util.sleep(500L);
        SharedTransportTest.assertSize(1, rec_b, rec_c);
        SharedTransportTest.assertSize(0, rec_a);
        this.a.close();
        this.b.send(null, null, (Serializable)((Object)"second"));
        Util.sleep(500L);
        SharedTransportTest.assertSize(0, rec_a);
        SharedTransportTest.assertSize(2, rec_b, rec_c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentCreation() throws ChannelException, InterruptedException {
        this.a = this.createSharedChannel(SINGLETON_1);
        this.r1 = new MyReceiver("a");
        this.a.setReceiver(this.r1);
        this.b = this.createSharedChannel(SINGLETON_1);
        this.r2 = new MyReceiver("b");
        this.b.setReceiver(this.r2);
        this.c = this.createSharedChannel(SINGLETON_1);
        this.r3 = new MyReceiver("c");
        this.c.setReceiver(this.r3);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch finishLatch = new CountDownLatch(3);
        ConnectTask connectA = new ConnectTask(this.a, "a", startLatch, finishLatch);
        Thread threadA = new Thread(connectA);
        threadA.setDaemon(true);
        threadA.start();
        ConnectTask connectB = new ConnectTask(this.b, "b", startLatch, finishLatch);
        Thread threadB = new Thread(connectB);
        threadB.setDaemon(true);
        threadB.start();
        ConnectTask connectC = new ConnectTask(this.c, "c", startLatch, finishLatch);
        Thread threadC = new Thread(connectC);
        threadC.setDaemon(true);
        threadC.start();
        startLatch.countDown();
        try {
            boolean finished = finishLatch.await(20L, TimeUnit.SECONDS);
            if (connectA.exception != null) {
                AssertJUnit.fail((String)("connectA threw exception " + connectA.exception));
            }
            if (connectB.exception != null) {
                AssertJUnit.fail((String)("connectB threw exception " + connectB.exception));
            }
            if (connectC.exception != null) {
                AssertJUnit.fail((String)("connectC threw exception " + connectC.exception));
            }
            if (!finished) {
                if (threadA.isAlive()) {
                    AssertJUnit.fail((String)"threadA did not finish");
                }
                if (threadB.isAlive()) {
                    AssertJUnit.fail((String)"threadB did not finish");
                }
                if (threadC.isAlive()) {
                    AssertJUnit.fail((String)"threadC did not finish");
                }
            }
        }
        finally {
            if (threadA.isAlive()) {
                threadA.interrupt();
            }
            if (threadB.isAlive()) {
                threadB.interrupt();
            }
            if (threadC.isAlive()) {
                threadC.interrupt();
            }
        }
    }

    private static void assertSize(int expected, MyReceiver ... receivers) {
        for (MyReceiver recv : receivers) {
            SharedTransportTest.assertEquals(expected, recv.size());
        }
    }

    private JChannel createSharedChannel(String singleton_name) throws ChannelException {
        ProtocolStackConfigurator config = ConfiguratorFactory.getStackConfigurator(this.channel_conf);
        ProtocolData[] protocols = config.getProtocolStack();
        ProtocolData transport = protocols[0];
        transport.getParameters().put("singleton_name", new ProtocolParameter("singleton_name", singleton_name));
        return new JChannel(config);
    }

    protected static void makeUnique(Channel channel, int num) throws Exception {
        ProtocolStack stack = channel.getProtocolStack();
        TP transport = stack.getTransport();
        InetAddress bind_addr = transport.getBindAddressAsInetAddress();
        if (transport instanceof UDP) {
            String mcast_addr = ResourceManager.getNextMulticastAddress();
            short mcast_port = ResourceManager.getNextMulticastPort(bind_addr);
            ((UDP)transport).setMulticastAddress(InetAddress.getByName(mcast_addr));
            ((UDP)transport).setMulticastPort(mcast_port);
        } else if (transport instanceof BasicTCP) {
            List<Short> ports = ResourceManager.getNextTcpPorts(bind_addr, num);
            transport.setBindPort(ports.get(0).shortValue());
            transport.setPortRange(num);
            Protocol ping = stack.findProtocol((Class<?>)TCPPING.class);
            if (ping == null) {
                throw new IllegalStateException("TCP stack must consist of TCP:TCPPING - other config are not supported");
            }
            LinkedList<String> initial_hosts = new LinkedList<String>();
            for (short port : ports) {
                initial_hosts.add(bind_addr + "[" + port + "]");
            }
            String tmp = Util.printListWithDelimiter(initial_hosts, ",");
            List<IpAddress> init_hosts = Util.parseCommaDelimitedHosts(tmp, 1);
            ((TCPPING)ping).setInitialHosts(init_hosts);
        } else {
            throw new IllegalStateException("Only UDP and TCP are supported as transport protocols");
        }
    }

    private static class ConnectTask
    implements Runnable {
        private final Channel channel;
        private final String clusterName;
        private final CountDownLatch startLatch;
        private final CountDownLatch finishLatch;
        private Exception exception;

        ConnectTask(Channel channel, String clusterName, CountDownLatch startLatch, CountDownLatch finishLatch) {
            this.channel = channel;
            this.clusterName = clusterName;
            this.startLatch = startLatch;
            this.finishLatch = finishLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startLatch.await();
                this.channel.connect(this.clusterName);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                this.exception = e;
            }
            finally {
                this.finishLatch.countDown();
            }
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        final List<Message> list = new LinkedList<Message>();
        final String name;

        private MyReceiver(String name) {
            this.name = name;
        }

        public List<Message> getList() {
            return this.list;
        }

        public int size() {
            return this.list.size();
        }

        public void clear() {
            this.list.clear();
        }

        @Override
        public void receive(Message msg) {
            System.out.println("[" + this.name + "]: received message from " + msg.getSrc() + ": " + msg.getObject());
            this.list.add(msg);
        }

        @Override
        public void viewAccepted(View new_view) {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + this.name + "]: view = " + new_view);
            System.out.println(sb);
        }

        public String toString() {
            return super.toString() + " (size=" + this.list.size() + ")";
        }
    }
}

