/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.logging;

import com.viettel.mmserver.base.ProcessThreadMX;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityFileChannel
extends ProcessThreadMX {
    private Map<String, Vector<byte[]>> contents = new HashMap<String, Vector<byte[]>>();
    private Map<String, File> files = new HashMap<String, File>();
    private static SecurityFileChannel instance = null;

    public static synchronized SecurityFileChannel getInstance() {
        if (instance == null) {
            instance = new SecurityFileChannel();
        }
        return instance;
    }

    private SecurityFileChannel() {
        super("FileChannel", "Security file channnel");
        try {
            this.registerAgent("logging:type=LogWriter, name=" + this.threadName);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Register JMX agent error: " + ex));
        }
        super.start();
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public void writeLn(String dir, String fileName, String content) throws IOException {
        Vector<Object> fBytes;
        String path = dir + File.separator + fileName;
        File file = this.files.get(path);
        if (file == null) {
            File directory = new File(dir);
            if (!directory.exists()) {
                this.logger.info((Object)("Directory " + dir + " does not exit, " + "created new directory"));
                directory.mkdir();
            }
            file = new File(path);
            this.files.put(path, file);
        }
        if ((fBytes = this.contents.get(path)) == null) {
            fBytes = new Vector();
            this.contents.put(path, fBytes);
        }
        content = content + "\n";
        byte[] bytes = content.getBytes();
        fBytes.add(bytes);
        this.logger.debug((Object)"A message added to cache");
    }

    private void writeAll() throws IOException {
        for (String path : this.contents.keySet()) {
            Vector<byte[]> bytes = this.contents.get(path);
            if (bytes.isEmpty()) {
                return;
            }
            File file = this.files.get(path);
            if (file == null) continue;
            this.write(file, bytes);
        }
    }

    private void write(File file, Vector<byte[]> bytes) throws IOException {
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        this.logger.info((Object)"Lock file for write operation");
        FileLock flock = channel.lock();
        for (int i = 0; i < bytes.size(); ++i) {
            byte[] aMsg = bytes.get(i);
            ByteBuffer bf = ByteBuffer.wrap(aMsg);
            channel.write(bf, file.length());
            this.logger.debug((Object)"Writen a message to file");
        }
        bytes.clear();
        flock.release();
        channel.close();
        this.logger.info((Object)"File unlocked");
    }

    protected void process() {
        try {
            this.writeAll();
        }
        catch (IOException ex) {
            this.logger.error((Object)("Error when write to file: " + ex));
            ex.printStackTrace();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            this.logger.error((Object)("Interupted thead: " + ex));
            ex.printStackTrace();
        }
    }
}

