/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.cluster.agent;

import com.viettel.cluster.agent.ClusterAgent;
import com.viettel.cluster.agent.Policy;
import com.viettel.cluster.agent.integration.DbProcessor;
import com.viettel.cluster.agent.integration.Record;
import com.viettel.cluster.agent.utils.ConfigHolder;
import com.viettel.cluster.agent.utils.ConfigLoader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.jgroups.ChannelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dispatcher {
    private DispatcherState state;
    private Queue<Record> queue = new LinkedList<Record>();
    private final List<Long> processingList = Collections.synchronizedList(new ArrayList());
    private final Object lock = new Object();
    private static int loadTimes = 0;
    private static int timeoutTimes = 1;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private Logger logger;
    private DbProcessor dbProcessor;
    private Policy policy;
    private ClusterAgent agent;
    private ConfigHolder configHolder;
    private RecordLoader loader;
    private static final Map<ConfigHolder, Dispatcher> DISPATCHER_MAP = new HashMap<ConfigHolder, Dispatcher>();

    ExecutorService getExecutor() {
        return this.executor;
    }

    Logger getLogger() {
        return this.logger;
    }

    DbProcessor getDbProcessor() {
        return this.dbProcessor;
    }

    ClusterAgent getAgent() {
        return this.agent;
    }

    ConfigHolder getConfigHolder() {
        return this.configHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dispatcher createInstance(DbProcessor dbProcessor, String id, Logger logger) {
        Dispatcher dis = null;
        ConfigHolder configHolder = ConfigLoader.getInstance().getConfigHolder(id);
        if (configHolder != null) {
            Map<ConfigHolder, Dispatcher> map = DISPATCHER_MAP;
            synchronized (map) {
                if (!DISPATCHER_MAP.containsKey(configHolder)) {
                    dis = new Dispatcher(dbProcessor, configHolder, logger);
                    DISPATCHER_MAP.put(configHolder, dis);
                }
            }
        }
        return dis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dispatcher getInstance(String id) {
        Dispatcher dis = null;
        ConfigHolder configHolder = ConfigLoader.getInstance().getConfigHolder(id);
        if (configHolder != null) {
            Map<ConfigHolder, Dispatcher> map = DISPATCHER_MAP;
            synchronized (map) {
                dis = DISPATCHER_MAP.get(configHolder);
            }
        }
        return dis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Map<ConfigHolder, Dispatcher> map = DISPATCHER_MAP;
        synchronized (map) {
            for (Dispatcher dispatcher : DISPATCHER_MAP.values()) {
                dispatcher.agent.destroy();
            }
            DISPATCHER_MAP.clear();
        }
    }

    private Dispatcher(DbProcessor dbProcessor, ConfigHolder configLoader, Logger logger) {
        this.dbProcessor = dbProcessor;
        this.configHolder = configLoader;
        this.logger = logger;
        this.loader = new RecordLoader();
        this.policy = new Policy(this);
        this.state = DispatcherState.READY;
        logger.debug((Object)("Node is " + (Object)((Object)this.state)));
        logger.debug((Object)("Create Dispatcher with params: \nCluster name: " + configLoader.getClusterName() + "\nIP: " + configLoader.getIp() + "\nNode Name: " + configLoader.getNodeName() + "\ninitital Hosts: " + configLoader.getInitialHosts() + "\nSqlMo: " + configLoader.getSqlMoPattern()));
        this.agent = new ClusterAgent(this);
        try {
            this.agent.start();
        }
        catch (ChannelException ex) {
            logger.error((Object)("Can't start agent " + (Object)((Object)ex)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onViewChanged(int nbMembers, int order) {
        if (this.dbProcessor.checkDatabase() != 0) {
            if (nbMembers < 2) {
                this.logger.warn((Object)ConfigLoader.changedViewCannotConnectDb);
            } else {
                this.logger.warn((Object)ConfigLoader.changedViewCannotConnectDb2);
            }
        }
        this.policy.createNewPolicy(nbMembers, order);
        switch (this.state) {
            case RUNNING: 
            case WAIT_TO_LOAD_MESSAGES: {
                Object object = this.lock;
                synchronized (object) {
                    this.logger.debug((Object)("Switch state from " + (Object)((Object)this.state) + " to WAIT_TO_APPLY_NEW_POLICY"));
                    this.state = DispatcherState.WAIT_TO_APPLY_NEW_POLICY;
                }
                this.checkReady();
                break;
            }
            case READY: {
                this.logger.debug((Object)("I'm " + (Object)((Object)this.state) + ". Wait others ready"));
                this.agent.notifyReady();
                break;
            }
            case LOADING_MESSAGES: {
                Object object = this.lock;
                synchronized (object) {
                    this.queue.clear();
                    this.logger.debug((Object)("Switch state from " + (Object)((Object)this.state) + " to READY"));
                    this.state = DispatcherState.READY;
                }
                this.agent.notifyReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReady() {
        int i = 0;
        while ((long)i < this.configHolder.getTimeout() / this.configHolder.getCheckInterval()) {
            if (this.processingList.size() != 0) {
                try {
                    Thread.sleep(this.configHolder.getCheckInterval());
                }
                catch (InterruptedException ex) {
                    this.logger.debug((Object)"Sleeping check interval on checkReady fail");
                }
            } else {
                this.logger.debug((Object)("Switch state from " + (Object)((Object)this.state) + " to READY"));
                this.state = DispatcherState.READY;
                break;
            }
            ++i;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state == DispatcherState.WAIT_TO_APPLY_NEW_POLICY) {
                this.logger.debug((Object)"Timeout when waiting ready checker");
                this.processTimeoutRecords();
                this.logger.debug((Object)("Switching state from " + (Object)((Object)this.state) + " to READY"));
                this.state = DispatcherState.READY;
            }
            this.queue.clear();
        }
        this.agent.notifyReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReady() {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug((Object)("Switch state from " + (Object)((Object)this.state) + " to RUNNING"));
            this.state = DispatcherState.RUNNING;
            this.logger.debug((Object)("Apply a new policy: " + this.policy.getSqlStatement()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> getRecords(int number) {
        ArrayList<Record> list = new ArrayList<Record>();
        Record temp = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.state == DispatcherState.RUNNING) {
                int min = this.queue.size() > number ? number : this.queue.size();
                for (int i = 0; i < min && this.state == DispatcherState.RUNNING; ++i) {
                    temp = this.queue.remove();
                    list.add(temp);
                    List<Long> list2 = this.processingList;
                    synchronized (list2) {
                        this.processingList.add(new Long(temp.getID()));
                        continue;
                    }
                }
                if (this.state == DispatcherState.RUNNING && this.queue.size() == 0) {
                    this.logger.debug((Object)("Switch state from " + (Object)((Object)this.state) + " to WAIT_TO_LOAD_MESSAGES"));
                    this.state = DispatcherState.WAIT_TO_LOAD_MESSAGES;
                    this.executor.execute(this.loader);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int updateProcessedRecord(List<Long> idList) {
        int result = this.dbProcessor.updateProcessedRecord(idList);
        List<Long> list = this.processingList;
        synchronized (list) {
            this.processingList.removeAll(idList);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimeoutRecords() {
        List<Long> list = this.processingList;
        synchronized (list) {
            if (this.configHolder.isEnableExtraLog()) {
                int nb = 1;
                StringBuffer buf = new StringBuffer("\n The " + timeoutTimes + " timeout: ");
                for (Long id : this.processingList) {
                    if (nb % 10 == 0) {
                        buf.append("\n The " + timeoutTimes + " timeout: " + id + " ");
                        nb = 1;
                        continue;
                    }
                    buf.append(id + " ");
                    ++nb;
                }
                this.logger.debug((Object)buf.toString());
            }
            this.dbProcessor.processTimeoutRecord(this.processingList);
            this.processingList.clear();
        }
        ++timeoutTimes;
    }

    private void showLoadedRecords() {
        if (this.configHolder.isEnableExtraLog()) {
            int nb = 1;
            StringBuffer buf = new StringBuffer("\n The " + loadTimes + " load: ");
            for (Record mo : this.queue) {
                if (nb % 10 == 0) {
                    buf.append("\n The " + loadTimes + " load: " + mo.getID() + " ");
                    nb = 1;
                    continue;
                }
                buf.append(mo.getID() + " ");
                ++nb;
            }
            this.logger.debug((Object)buf.toString());
        }
    }

    private class RecordLoader
    implements Runnable {
        private RecordLoader() {
        }

        public void run() {
            int i = 0;
            while ((long)i < Dispatcher.this.configHolder.getTimeout() / Dispatcher.this.configHolder.getCheckInterval() && Dispatcher.this.state == DispatcherState.WAIT_TO_LOAD_MESSAGES) {
                ++i;
                if (Dispatcher.this.processingList.size() == 0) {
                    this.loadMoMessages();
                    return;
                }
                try {
                    Thread.sleep(Dispatcher.this.configHolder.getCheckInterval());
                }
                catch (InterruptedException ex) {
                    Dispatcher.this.logger.debug((Object)"Sleeping check interval on RecordLoader fail");
                }
            }
            if (Dispatcher.this.state == DispatcherState.WAIT_TO_LOAD_MESSAGES) {
                Dispatcher.this.logger.debug((Object)"Timeout when waiting to load message.");
                Dispatcher.this.processTimeoutRecords();
                this.loadMoMessages();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void loadMoMessages() {
            block31: {
                Object object = Dispatcher.this.lock;
                synchronized (object) {
                    if (Dispatcher.this.state == DispatcherState.WAIT_TO_LOAD_MESSAGES) {
                        Dispatcher.this.logger.debug((Object)("Switch state from " + (Object)((Object)Dispatcher.this.state) + " to LOADING_MESSAGES"));
                        Dispatcher.this.state = DispatcherState.LOADING_MESSAGES;
                    }
                }
                ResultSet rs = null;
                rs = Dispatcher.this.dbProcessor.getRecords();
                loadTimes++;
                if (rs != null) {
                    while (rs.next() && Dispatcher.this.state == DispatcherState.LOADING_MESSAGES) {
                        Object object2 = Dispatcher.this.lock;
                        synchronized (object2) {
                            Record record = Dispatcher.this.dbProcessor.parse(rs);
                            Dispatcher.this.queue.add(record);
                        }
                    }
                }
                Object var6_7 = null;
                Object object3 = Dispatcher.this.lock;
                synchronized (object3) {
                    if (Dispatcher.this.state == DispatcherState.LOADING_MESSAGES) {
                        Dispatcher.this.logger.debug((Object)("Switch state from " + (Object)((Object)Dispatcher.this.state) + " to RUNNING"));
                        Dispatcher.this.state = DispatcherState.RUNNING;
                        Dispatcher.this.showLoadedRecords();
                    }
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    break block31;
                }
                catch (SQLException ex2) {
                    rs = null;
                }
                break block31;
                {
                    catch (Exception ex) {
                        Dispatcher.this.logger.debug((Object)(new Date() + "\nERROR process" + ex.getMessage()));
                        Object var6_8 = null;
                        Object object4 = Dispatcher.this.lock;
                        synchronized (object4) {
                            if (Dispatcher.this.state == DispatcherState.LOADING_MESSAGES) {
                                Dispatcher.this.logger.debug((Object)("Switch state from " + (Object)((Object)Dispatcher.this.state) + " to RUNNING"));
                                Dispatcher.this.state = DispatcherState.RUNNING;
                                Dispatcher.this.showLoadedRecords();
                            }
                        }
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            break block31;
                        }
                        catch (SQLException ex2) {
                            rs = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    Object object5 = Dispatcher.this.lock;
                    synchronized (object5) {
                        if (Dispatcher.this.state == DispatcherState.LOADING_MESSAGES) {
                            Dispatcher.this.logger.debug((Object)("Switch state from " + (Object)((Object)Dispatcher.this.state) + " to RUNNING"));
                            Dispatcher.this.state = DispatcherState.RUNNING;
                            Dispatcher.this.showLoadedRecords();
                        }
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException ex2) {
                        rs = null;
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DispatcherState {
        RUNNING,
        READY,
        WAIT_TO_LOAD_MESSAGES,
        LOADING_MESSAGES,
        WAIT_TO_APPLY_NEW_POLICY;

    }
}

